<?php

/**
 * Description of sfGuardUserAdminChangePasswordForm
 *
 
 */
class sfGuardUserAdminChangePasswordForm extends BaseFormDoctrine
{

  public function setup()
  {
    $this->widgetSchema['password'] = new sfWidgetFormInputPassword();
    $this->validatorSchema['password'] = new sfArtValidatorPassword(array('required' => false));
    $this->widgetSchema['password_again'] = new sfWidgetFormInputPassword();
    $this->validatorSchema['password_again'] = clone $this->validatorSchema['password'];

    $this->widgetSchema->moveField('password_again', 'after', 'password');

    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Oba hasła muszą być identyczne.')));

    $this->widgetSchema->setNameFormat('sf_guard_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'sfGuardUser';
  }

  public function save($con = null)
  {
    if ($this->values['password'] != false)
    {
      $user = $this->getObject();
      $user->setPassword($this->values['password']);
      $user->save();
    }
    
    return $this->getObject();
  }

}