<?php

/**
 * Permission table.
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage model
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: PluginsfGuardPermissionTable.class.php 23793 2009-11-11 17:42:50Z Kris.Wallsmith $
 */
abstract class PluginsfGuardPermissionTable extends artDoctrineTable
{
  
  public function getPermissionsByGroupName($groupName, $onlyField = false)
  {
    $query = $this->createQuery('p')
            ->leftJoin('p.Groups g')
            ->where('g.name = ?', $groupName);
            
    
    if ($onlyField !== false)
      return $query
                  ->select('p.' . $onlyField)
                  ->execute(array(), Doctrine_Core::HYDRATE_SINGLE_SCALAR);
    else
      return $query->execute();
  }
  
  public function getByNames($names = array())
  {
    return $this->createQuery('p')
            ->whereIn('p.name', $names)
            ->execute();
  }
}
