<?php

/**
 * User group reference table.
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage model
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: PluginsfGuardUserGroupTable.class.php 23793 2009-11-11 17:42:50Z Kris.Wallsmith $
 */
abstract class PluginsfGuardUserGroupTable extends artDoctrineTable
{
  /**
   * Zwraca rekord po grupie i uzytkowniku
   * 
   * @param int $groupId
   * @param int $userId
   * @return object
   */
  public function getObject($groupId, $userId) {
    return $this->createQuery('sgu')
        ->where('sgu.group_id = ?', $groupId)
        ->andWhere('sgu.user_id = ?', $userId)
        ->fetchOne();
  }
}
