<?php

/**
 * User table.
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage model
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: PluginsfGuardUserTable.class.php 25546 2009-12-17 23:27:55Z Jonathan.Wage $
 */
abstract class PluginsfGuardUserTable extends artDoctrineTable
{
  
  public function getByIds($users) {
    if (count($users) == 0) {
      return array();
    }
    return $this->createQuery('sgu')
        ->whereIn('sgu.id', $users)
        ->execute();
  }

  /**
   * Retrieves a sfGuardUser object by username and is_active flag.
   *
   * @param  string  $username The username
   * @param  boolean $isActive The user's status
   *
   * @return sfGuardUser
   */
  public function retrieveByUsername($username, $isActive = true)
  {
    $query = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
            ->where('u.username = ?', $username)
            ->addWhere('u.is_active = ?', $isActive)
    ;

    return $query->fetchOne();
  }

  /**
   * Retrieves a sfGuardUser object by username or email_address and is_active flag.
   *
   * @param  string  $username The username
   * @param  boolean $isActive The user's status
   *
   * @return sfGuardUser
   */
  public function retrieveByUsernameOrEmailAddress($username, $isActive = true)
  {
    $query = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
            ->where('u.username = ? OR u.email_address = ?', array($username, $username))
            ->addWhere('u.is_active = ?', $isActive)
    ;

    return $query->fetchOne();
  }

  public function getSessionGuardUser($id)
  {
    $query = $this->createQuery('sfgu')
            ->where('sfgu.id = ?', $id);

    if (SchemaConfig::isGuardSoftDeleted())
      $query->andWhere('sfgu.deleted_at IS NULL');

    return $query->fetchOne();
  }

  public function getUsersWithoutLoggedInAndSystem()
  {
    return $this->createQuery('sfgu')
            ->where('sfgu.id <> ?', $this->getUserId())
            ->andWhere('sfgu.username <> ?', sfGuardUser::$systemAccountUsername);
  }

  public function getUserObjectForCollector($userId = null, $username = null)
  {
    $query = $this->createQuery('sfgu');

    if (!is_null($userId))
      $query->where('sfgu.id = ?', $userId);
    else
      $query->where('sfgu.username = ?', $username);

    return $query->fetchOne();
  }

  public function userDataDelete($ids)
  {
    $this->clearData($ids);

    $query = Doctrine_Query::create()->update('UserDetail ud');
    $query->set('birth_date', '?', '0000-00-00');
    $query->whereIn('ud.id', $ids);
    $query->execute();
  }
  
  public function clearData($ids)
  {
    $query = Doctrine_Query::create()->update('sfGuardUser su');
    $query->set('su.first_name', '?', 'NULL');
    $query->set('su.last_name', '?', 'NULL');
    $query->set('su.username', 'su.id');
    $query->set('su.email_address', 'su.id');
    $query->set('su.salt', 'su.id');
    $query->set('su.password', 'su.id');
    $query->set('su.is_active', 0);
    $query->set('su.is_super_admin', 0);
    $query->set('su.deleted_at', 'NOW()');
    $query->whereIn('su.id', $ids);
    $query->execute();
  }

  public function getFlatySfGuardUser() {
    return $this->createQuery('sgu')
        ->leftJoin('sgu.Groups as sgg')
        ->leftJoin('sgu.Permissions as sgp');
  }
  
}
