<?php

class sfDoctrineGuardPluginRedirector
{
  public static function getGuardUser_SignOut($params)  
  {
    $default = '';
    if (isset ($params['request']))
    {
      $request = $params['request'];
      $default = $request->getReferer();
    }
      
    $signoutUrl = sfConfig::get('app_sf_guard_plugin_success_signout_url', $default);

    return '' != $signoutUrl ? $signoutUrl : '@homepage';
  }
  
  public static function getGuardUser_SignInAuthenticated($params)  
  {
    return '@homepage';
  }
  
  public static function getGuardUser_SignIn($params)  
  {
    if (isset($params['referer'])) {
      $signinUrl = sfConfig::get('app_sf_guard_plugin_success_signin_url', $params['referer']);
    } else {
      $signinUrl = '';
    }
    
    return '' != $signinUrl ? $signinUrl : '@homepage';
  }
  /**
   * Funkcja zwraca podana nizej tablice, poniewaz jest przeznaczona do wykorzystania
   * przez funkcje forward
   * 
   * @param type $params
   * @return string 
   */
  public static function getGuardUser_ActivateErrorForward($params)  
  {
    $forward = array(
        'module' => 'sfGuardAuth',
        'action' => 'signin',
    );
    return $forward;
  }
  /**
   * Jesli nadpiszemy i zwrocimy cos innego niz false to bedzie zrobiony redirect
   * 
   * @param type $params
   * @return boolean 
   */
  public static function getGuardUser_AlreadyActive($params)  
  {
    // $user = $params['user'];
    // sfGuardUser $user
    return false;
  }
  
  /**
   * Jesli nadpiszemy i zwrocimy cos innego niz false to bedzie zrobiony redirect
   * 
   * @param type $params
   * @return boolean 
   */
  public static function getGuardUser_Activate($params)  
  {
    // $user = $params['user'];
    // sfGuardUser $user
    return false;
  }
  
  /** Przekierowania AJAX **/
  /** Uzywane w akcji : return $this->renderText(Redirector::get('XYZ'));**/
  
  /**
   * Przekierowanie po pomyslnym zalogowaniu przez AJAX.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getAjaxSinginSuccess($params)  
  {
    return 'Success';
  }
  
  /**
   * Przekierowanie po pomyslnej zmianie hasla
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getAjaxChangePasswordSuccess($params)  
  {
    $params['user']->setNotice(_('Hasło zostało zmienione.'));
    return 'Success';
  }
  
  /** KONIEC - Przekierowania AJAX **/
}