<?php

class artGuardPasswordValidator extends sfValidatorSchema
{
  /**
   * Konstruktor
   *
   * Dostepne opcje:
   *
   *  * password_field: Nazwa pola z haslem w formularzu
   *  * userObject: obiekt sfGuardUser
   *
   * @param string $passwordField   Nazwa pola z haslem w formularzu
   * @param string $userObject    obiekt sfGuardUser
   * @param array  $options     An array of options
   * @param array  $messages    An array of error messages
   *
   * @see sfValidatorBase
   */
  public function __construct($passwordField, $userObject, $options = array(), $messages = array())
  {
    $this->addOption('password_field', $passwordField);
    $this->addOption('user', $userObject);

    $this->addOption('throw_global_error', false);

    parent::__construct(null, $options, $messages);
  }

  /**
   * @see sfValidatorBase
   */
  protected function doClean($values)
  {
    if (null === $values)
    {
      $values = array();
    }

    if (!is_array($values))
    {
      throw new InvalidArgumentException('You must pass an array parameter to the clean() method');
    }

    $passwordValue  = isset($values[$this->getOption('password_field')]) ? $values[$this->getOption('password_field')] : null;

    $valid = $this->getOption('user')->checkPassword($passwordValue);

    if (!$valid)
    {
      $error = new sfValidatorError($this, 'Niepoprawne hasło', array(
        'password_field'  => $passwordValue,
      ));
      
      if ($this->getOption('throw_global_error'))
      {
        throw $error;
      }

      throw new sfValidatorErrorSchema($this, array($this->getOption('password_field') => $error));
    }

    return $values;
  }
}
