<?php

require_once dirname(__FILE__) . '/../lib/flatySfGuardUserGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/flatySfGuardUserGeneratorHelper.class.php';

/**
 * flatySfGuardUser
 *
 * @subpackage artCmsPlugin

 */
class PluginflatySfGuardUserActions extends autoFlatySfGuardUserActions {

  public function preExecute() {
    $this->configuration = new flatySfGuardUserGeneratorConfiguration();

    if (!$this->getUser()->hasCredential($this->configuration->getCredentials($this->getActionName()))) {
      $this->forward(sfConfig::get('sf_secure_module'), sfConfig::get('sf_secure_action'));
    }

    $this->dispatcher->notify(new sfEvent($this, 'admin.pre_execute', array('configuration' => $this->configuration)));

    $this->helper = new flatySfGuardUserGeneratorHelper();
    $this->helper->setConfigurationObject($this->configuration);
    $this->helper->setSfGuardGroups(Doctrine::GetTable('sfGuardGroup')->findAll());

    if (!$this->hasFilterParam()) {
      $this->setFilterParam(' ');
    }
  }

  public function executeAddSfGuardGroup(sfWebRequest $request) {
    $sfGuardUser = $this->getRoute()->getObject();
    $sfGuardGroup = Doctrine::getTable('sfGuardGroup')->findOneById($request->getParameter('group_id', -1));

    if ($sfGuardGroup) {
      try {
        $sfGuardUserGroup = new sfGuardUserGroup();
        $sfGuardUserGroup->setGroupId($sfGuardGroup->getId());
        $sfGuardUserGroup->setUserId($sfGuardUser->getId());
        $sfGuardUserGroup->save();
        $this->getUser()->setNotice('Dodano użytkownika "'.$sfGuardUser->getEmailAddress().'" do grupy "'.$sfGuardGroup->getDescription().'"');
      } catch (Exception $ex) {
        $this->getUser()->setError('Wystąpił błąd. Spróbuj ponownie, a jeśli błąd się powtórzy skontaktuj się z administratorem.');
      }
    } else {
      $this->getUser()->setError('Grupa do której chcesz dodać użytkownika nie istnieje');
    }

    $this->redirect('@flatySfGuardUser');
  }
  
  public function executeDeleteSfGuardGroup(sfWebRequest $request) {
    $sfGuardUser = $this->getRoute()->getObject();
    $sfGuardGroup = Doctrine::getTable('sfGuardGroup')->findOneById($request->getParameter('group_id', -1));

    if ($sfGuardGroup) {
      try {
        $sfGuardUserGroup = Doctrine::getTable('sfGuardUserGroup')->getObject($sfGuardGroup->getId(), $sfGuardUser->getId());
        if ($sfGuardUserGroup) {
          $sfGuardUserGroup->delete();
          $this->getUser()->setNotice('Usunięto użytkownika "'.$sfGuardUser->getEmailAddress().'" z grupy "'.$sfGuardGroup->getDescription().'"');
        } else {
          $this->getUser()->setError('Użytkownik nie jest przypisany do podanej grupy');
        }
      } catch (Exception $ex) {
        $this->getUser()->setError('Wystąpił błąd. Spróbuj ponownie, a jeśli błąd się powtórzy skontaktuj się z administratorem');
      }
    } else {
      $this->getUser()->setError('Grupa z której chcesz usunąć użytkownika nie istnieje');
    }

    $this->redirect('@flatySfGuardUser');
  }
  
  public function executeChangeSfGuardUserPassword(sfWebRequest $request) {
    $sfGuardUser = Doctrine::getTable('sfGuardUser')->findOneById($request->getParameter('id'));
    $this->form = new FlatyChangeUserPasswordForm($sfGuardUser);

    if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
      $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));
      if ($this->form->isValid()) {
        $this->form->save();
        $this->getUser()->setNotice('Hasło użytkownika "'.$sfGuardUser->getName().'" zostało pomyślnie zmienione');
        $this->redirect('@flatySfGuardUser');
      }
    }
  }

}
