<?php

/**
 *
 * @package    symfony
 * @subpackage plugin
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: actions.class.php 23319 2009-10-25 12:22:23Z Kris.Wallsmith $
 */
class PluginsfGuardAuthActions extends artActions {

  public function executeSignin(sfWebRequest $request) {
    $user = $this->getUser();

    if ($user->isAuthenticated()) {
      if (!$request->isXmlHttpRequest())
        return $this->redirect(Redirector::get('GuardUser_SignInAuthenticated', array('request' => $request)));
      else {
        $this->url = url_for(Redirector::get('GuardUser_SignInAuthenticated', array('request' => $request)));
        return 'Redirect';
      }
    }

    if ($this->getUser()->hasFlash('homepageReferer'))
      $this->getUser()->setFlash('homepage_referer', $this->getUser()->getFlash('homepageReferer'));
    else
      $this->getUser()->forwardFlash('homepage_referer');

    $class = sfConfig::get('app_sf_guard_plugin_signin_form', 'sfGuardFormSignin');
    $this->form = new $class();

    if ($request->isMethod('post') && $request->hasParameter('signin')) {
      $this->form->bind($request->getParameter('signin'));

      if ($this->form->isValid()) {
        $values = $this->form->getValues();
        $this->getUser()->signin($values['user'], array_key_exists('remember', $values) ? $values['remember'] : false);

        $referer = $user->getReferer($request->getReferer());

        $this->url = Redirector::get('GuardUser_SignIn', array('request' => $request, 'referer' => $referer, 'user' => $user));

        if ($this->getUser()->hasFlash('homepage_referer')) {
          $this->url = $this->getUser()->getFlash('homepage_referer');

          return 'Redirect';
        }

        if ($request->isXmlHttpRequest() && $this->getUser()->hasAttribute('ajax_referer')) {
          $ajaxReferer = $this->getUser()->getAttribute('ajax_referer', $referer);
          $this->getUser()->offsetUnset('ajax_referer');
          $urlToParse = str_replace(str_replace(sfConfig::get('sf_web_dir'), '', $_SERVER['SCRIPT_FILENAME']) . '/', '', $ajaxReferer);
          $params = $this->getContext()->getRouting()->parse($urlToParse);

          if ($params['action'] == 'signin' && $params['module'] == 'sfGuardAuth')
            return 'Redirect';
          else
            return $this->forward($params['module'], $params['action']);
        }

        return $this->redirect($this->url);
      }
    }
    else {
      if ($request->isXmlHttpRequest()) {
        $this->getUser()->setAttribute('ajax_referer', $_SERVER['REQUEST_URI']);

        return 'Success';
      }

      $user->setReferer($this->getContext()->getActionStack()->getSize() > 1 ? $request->getUri() : $request->getReferer());
      $module = sfConfig::get('sf_login_module');

      if ($this->getModuleName() != $module)
        return $this->redirect($module . '/' . sfConfig::get('sf_login_action'));

      $this->getResponse()->setStatusCode(401);
    }

    $view = sfConfig::get('app_sf_guard_plugin_signin_view', 'FullWidth');
    $this->setLayout("layout_$view");
    return $view;
  }

  public function executeAjaxSignin(sfWebRequest $request) {

    if (!$this->getRequest()->isXmlHttpRequest()) {
      $this->redirect(Redirector::get('NotXmlHttp'));
    }

    $class = sfConfig::get('app_sf_guard_plugin_signin_form', 'sfGuardFormSignin');
    $this->form = new $class();

    if ($this->form->bindFromRequestAndSave($request)) {
      $values = $this->form->getValues();
      $this->getUser()->signIn($values['user'], array_key_exists('remember', $values) ? $values['remember'] : false);
      return $this->renderText(Redirector::get('AjaxSinginSuccess', array('user' => $this->getUser())));
    }
  }

  public function executeSignout($request) {
    $plugins = $this->getContext()->getConfiguration()->getPlugins();
    artDebug::logError(print_r($plugins, true));

    if (in_array('artFacebookPlugin', $plugins)) {
      artFacebook::signOut($this->getUser());
      artDebug::logError("LOGOUT FACEBOOK");
    }

    $this->getUser()->signOut();
    $this->redirect(Redirector::get('GuardUser_SignOut', array('request' => $request)));
  }

  public function executeSecure($request) {
    
  }

  public function executeActivate(sfWebRequest $request) {
    $this->email = $request->getParameter('e', null);
    $this->hashmd5 = $request->getParameter('u', null);

    if (is_null($this->email) || is_null($this->hashmd5)) {
      $redirector = Redirector::get('GuardUser_ActivateErrorForward');
      $this->forward($redirector['module'], $redirector['action']);
    }

    $user = Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($this->email);

    if (empty($user)) {
      $redirector = Redirector::get('GuardUser_ActivateErrorForward');
      $this->forward($redirector['module'], $redirector['action']);
    } else if ($this->hashmd5 == $user->getMd5ActivationCode()) {
      if ($user->getIsActive() == 1) {
        $this->getUser()->setFlash('notice', 'Twoje konto jest aktywne.');

        $redirector = Redirector::get('GuardUser_AlreadyActive', array('user' => $user));
        if ($redirector) {
          $this->redirect($redirector);
        } else {
          $this->setTemplate('activateAlready');
          return sfView::SUCCESS;
        }
      } else {
        $user->setIsActive(1);
        $user->save();

        ArtSimpleMessenger::sendActivationMessage($user);

        $redirector = Redirector::get('GuardUser_Activate', array('user' => $user));
        if ($redirector) {
          $this->redirect($redirector);
        } else {
          return sfView::SUCCESS;
        }
      }
    }

    $this->getUser()->setFlash('notice', 'Bad Url.');
    $redirector = Redirector::get('GuardUser_ActivateErrorForward');
    $this->forward($redirector['module'], $redirector['action']);
  }

  public function executePassword($request) {
    $this->user = $this->getUser()->getGuardUser();
    $this->form = new sfGuardChangeSigninPasswordForm($this->user);

    if ($request->isMethod('post') && $request->hasParameter('change_password')) {
      $this->form->bind($request->getParameter('change_password'));
      $oldPassword = $this->form->getValue('old_password');

      if ($this->form->isValid()) {
        if (!$this->getUser()->checkPassword($oldPassword))
          $this->getUser()->setError('Invalid old password.');
        else {
          $this->form->getObject()->setPassword($this->form->getValue('password'));
          $this->form->getObject()->save();

          ArtSimpleMessenger::sendNewPasswordMessage($this->user);

          $this->getUser()->setNotice('Hasło zostało zmienione.');
        }
      }
    }
  }

  /**
   * akcja do usunięcia nieuaktywnionego konta 
   * @param sfWebRequest $request 
   */
  public function executeDeleteNewUser(sfWebRequest $request) {
    if (!$request->hasParameter('hash'))
      $this->getUser()->setError('Invalid link.');
    else {
      $hash = $request->getParameter('hash');
      $user = ArtSimpleMessenger::extractDeleteUserHash($hash);

      if ($user === false || $user->getIsActive())
        $this->getUser()->setError('Invalid link.');
      else {
        $user->delete();
        $this->getUser()->setNotice('Konto zostało usunięte.');
      }
    }

    $this->redirect('@homepage');
  }

  /**
   * Akcja AJAX zmiany hasla
   * routing.yml: ajax_change_password
   * Wymagany zalogowany uzytkownik
   * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
   * 
   * @param sfWebRequest $request
   */
  public function executeAjaxChangePassword($request) {
    // Wymuszenie requesta AJAX
    if (!$this->getRequest()->isXmlHttpRequest()) {
      $this->redirect(Redirector::get('NotXmlHttp'));
    }
    // Sprawdzenie czy user jest zalogowany
    if (!$this->getUser()->isAuthenticated()) {
      return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
    }

    $this->form = new sfGuardChangeSigninPasswordForm($this->getUser()->getGuardUser());

    if ($this->form->bindFromRequestAndSave($request)) {
      ArtSimpleMessenger::sendNewPasswordMessage($this->getUser()->getGuardUser());
      return $this->renderText(Redirector::get('AjaxChangePasswordSuccess', array('user' => $this->getUser())));
    }
  }

  /**
   * akcja do usunięcia aktywowanego konta
   * @param sfWebRequest $request 
   */
  public function executeDeleteAccount(sfWebRequest $request) {
    if ($request->getParameter('hash') == '') {
      if ($request->hasParameter('delete')) {
        ArtSimpleMessenger::sendDeleteAccountMessage($this->getUser()->getGuardUser());

        $this->getUser()->setNotice('Link do usunięcia konta został wysłany. Sprawdź swój email.');

        $this->redirect('@homepage');
      }
    } else {
      $hash = $request->getParameter('hash');
      $user = ArtSimpleMessenger::extractDeleteAccountHash($hash);

      if ($user === false || $user->getIsActive())
        $this->getUser()->setError('Invalid link.');
      else {
        $user->delete();
        $this->getUser()->signout();
        $this->getUser()->setNotice('Twoje konto zostało usunięte pomyślnie.');

        $this->redirect('@homepage');
      }
    }
  }

  public function checkPasswordExpirationPeriod($userId) {
    return true;
  }

  public function setPasswordExpirationPeriod() {
    
  }

  public function executeAutoLogin() {
    $admin = Doctrine::getTable('sfGuardUser')->findOneByUsername('admin');

    $this->getUser()->signIn($admin, false);
    $this->redirect('@homepage');
  }

}
