<?php

/**
 * sfGuardForgotPassword actions.
 * 
 * @package    sfGuardForgotPasswordPlugin
 * @subpackage sfGuardForgotPassword
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12534 2008-11-01 13:38:27Z Kris.Wallsmith $
 */
class PluginsfGuardForgotPasswordActions extends artActions {

  public function preExecute() {
    if ($this->getUser()->isAuthenticated())
      $this->redirect('@homepage');
  }

  public function executeIndex($request) {
    $this->form = new sfGuardRequestForgotPasswordForm();

    if ($request->isMethod('post')) {
      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid()) {
        $this->user = Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($this->form->getValue('email_address'));
        $this->_deleteOldUserForgotPasswordRecords();

        $forgotPassword = new sfGuardForgotPassword();
        $forgotPassword->user_id = $this->user->getId();
        $forgotPassword->unique_key = md5(rand() + time());
        $forgotPassword->expires_at = new Doctrine_Expression('NOW()');
        $forgotPassword->save();

        ArtSimpleMessenger::sendResetPasswordMessage($forgotPassword->user_id, $forgotPassword->unique_key);

        $this->getUser()->setFlash('notice', 'Sprawdź email. Powinieneś na niego otrzymać link resetujący!');
      }
    }

    $view = sfConfig::get('app_sf_guard_plugin_forgot_password_view', 'FullWidth');
    $this->setLayout("layout_$view");
    return $view;
  }

  public function executeChange($request) {
    try {

      $this->forgotPassword = $this->getRoute()->getObject();
    } catch (Exception $e) {
      $this->getUser()->setNotice('Bad link.');
      $this->form = new sfGuardChangeUserPasswordForm();

      return sfView::SUCCESS;
    }
    $this->user = $this->forgotPassword->User;
    $this->form = new sfGuardChangeUserPasswordForm($this->user);

    if ($request->isMethod('post')) {
      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid()) {
        $this->form->save();
        $this->_deleteOldUserForgotPasswordRecords();
        ArtSimpleMessenger::sendNewPasswordMessage($this->user);
        $this->getUser()->setFlash('notice', 'Hasło zmienione pomyślnie!');

        if (!artSettings::isBackendApp())
          $this->redirect('@sf_guard_signin');
      }
    }
  }

  public function _deleteOldUserForgotPasswordRecords() {
    Doctrine_Core::getTable('sfGuardForgotPassword')
            ->createQuery('p')
            ->delete()
            ->where('p.user_id = ?', $this->user->id)
            ->execute();
  }

}
