<?php
/**
 * sfGuardRegister actions.
 *
 * @package    guard
 * @subpackage sfGuardRegister
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z jwage $
 */
class PluginsfGuardRegisterActions extends artActions
{

  public function preExecute()
  {
    if ($this->getUser()->isAuthenticated())
    {
      $this->getUser()->setFlash('notice', 'Jesteś już zarejestrowany i zalogowany!');
      $this->redirect('@homepage');
    }
  }

  public function executeIndex(sfWebRequest $request)
  {
    $class = class_exists('sfGuardRegisterForm') ? 'sfGuardRegisterForm' : 'PluginsfGuardRegisterForm';

    if (!$this->getUser()->hasFlash('email_from_invitation'))
      $this->form = new $class();
    else
    {
      $user = new sfGuardUser();
      $user->setEmailAddress($this->getUser()->getFlash('email_from_invitation'));
      $this->form = new $class($user, array('invitation' => true));
    }
    
    if ($request->isMethod('post') && $request->hasParameter($this->form->getName()))
    {
      $this->form->bind($request->getParameter($this->form->getName()));
      
      if ($this->form->isValid())
      {
        $user = $this->form->save();
        UserMessageSetting::setUserMessageSettings($user->getId());

        ArtSimpleMessenger::sendRegistrationMessage($user);
        $this->getUser()->setNotice('Dziękujemy za stworzenie konta na naszej stronie! Na twój e-mail została wysłana wiadomość z linkiem aktywacyjnym. Kliknięcie go spowoduje aktywację konta.');
        $this->redirect('@homepage');
      }
    }
    
    $view = sfConfig::get('app_sf_guard_plugin_register_view', 'FullWidth'); 
    $this->setLayout("layout_$view");
    return $view;
  }

}