<?php

require_once dirname(__FILE__) . '/../lib/sfGuardUserGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/sfGuardUserGeneratorHelper.class.php';

/**
 * sfGuardUser actions.
 *
 * @package    sfGuardPlugin
 * @subpackage sfGuardUser
 * @author     Fabien Potencier
 * @version    SVN: $Id: actions.class.php 23319 2009-10-25 12:22:23Z Kris.Wallsmith $
 */
class PluginsfGuardUserActions extends autoSfGuardUserActions
{

  public function executeChangePassword(sfWebRequest $request)
  {
    $userId = $request->getParameter('id');
    $this->user = Doctrine::getTable('sfGuardUser')->find($userId);
    $this->form = new sfGuardUserAdminChangePasswordForm($this->user);

    if ($request->isMethod('post') && $request->hasParameter($this->form->getName()))
    {
      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid())
      {
        $this->form->save();
        $this->getUser()->setFlash('notice', 'Hasło zostało zmodyfikowane pomyślnie.');
      }
    }
  }

  public function setForeignKeysValues(sfWebRequest $request)
  {
    $values['id'] = $request->getParameter('id');

    return $values;
  }

  public function getLinkFilterArray($paramArray = null)
  {
    $group = Doctrine::getTable('sfGuardGroup')->findOneByName('admin');

    if ($group)
      $groups = array($group->getId());
    else
      $groups = array();


    return array(
        'admins' => array(
            'groups_list' => $groups
        ),
        'banned' => array(
            'is_banned' => 1
        )
    );
  }

}
