/**
 * Ładuje funkcje po i przed Ajax. 
 */
var AjaxLoader = new Class({
}).extend({
    sumFormCosts: function() {
        if (AppConfig.widgetCosts) {

            var elements = $('[widgetCost]');
            var suma = 0;
            var zwrot = 0;

            Object.each(elements, function(value, key) {

                if (typeof (value.getAttribute) != "undefined") {

                    if (Helper.isNumber(value.getAttribute('widgetCost'))) {
                        suma = suma + parseInt(value.getAttribute('widgetCost'));
                    }
                }
            });

            Debug.info("[AjaxLoader] Nowe koszty z podjętych decyzji : " + Helper.formatMoneyValue(suma));

            $('#formSumCosts').hide();

            if (suma > 0) {
                $('#formSumCostsValue').html(Helper.formatMoneyValue(-suma));
                $('#formSumCosts a').attr('data-original-title', 'Szacowany koszt jednorazowy podjęcia decyzji');
                $('#formSumCosts').show();
            }
            if (suma < 0) {
                zwrot = -1 * suma;
                $('#formSumCostsValue').html(Helper.formatMoneyValue(zwrot));
                $('#formSumCosts a').attr('data-original-title', 'Szacowany zysk z podjęcia decyzji');
                $('#formSumCosts').show();
            }
        }

        if (AppConfig.widgetCostsRound) {

            var elements = $('[widgetCostRound]');
            var suma = 0;

            Object.each(elements, function(value, key) {

                if (typeof (value.getAttribute) != "undefined") {

                    if (Helper.isNumber(value.getAttribute('widgetCostRound'))) {
                        suma = suma + parseInt(value.getAttribute('widgetCostRound'));
                    }
                }
            });

            Debug.info("[AjaxLoader] Planowany koszt kwartalny z podjętych decyzji : " + Helper.formatMoneyValue(suma))

            $('#formSumCostsRound').hide();

            if (suma != 0) {
                $('#formSumCostsRoundValue').html(Helper.formatMoneyValue(suma));
                $('#formSumCostsRound').show();
            }
        }
    },
    loadAfterAjax: function(update) {

        if (isset(update)) {
            Helper.updateScroll();
        } else {
            Helper.setPopupSize();
            Helper.setScroll();

            if (AppConfig.loadMap) {
                if (isset(ige)) {
                    ige.stop();
                }
            }
        }

        if (AppConfig.helpPopover) {
            if ($('[tooltip="true"]'))
                $('[tooltip="true"]').tooltip({html: true});
        }

        $('#decision_form_pokoje_lux').attr('disabled', 'disabled');
        $('#decision_form_pokoje_standard').attr('disabled', 'disabled');

        this.sumFormCosts();

        $('[tableSorter="true"]').tablesorter();

        Debug.info("[AjaxLoader] Wykonuję funkcje po wykonaniu AJAX {" + CoreTimer.timestamp() + "}");

        $('#DecisionForm').unspin();
        $('html').unspin();
        $('.modal-spinner').hide();
        $('.global-spinner').hide();
        $('.modal-backdrop').not('.adviser-backdrop').remove();
        $('.modal').modal('show');


        var img = $('[scrollarea="true"] img');
        var length = img.length;

        img.load(function() {
            length--;

            if (length === 0) {
                Debug.info("All images loaded");
                Helper.updateScroll();
            }
            ;
        });

        $('.image-class-logo-firm').change(function() {

            Debug.info("[AjaxLoader] Disable Widget wybor_loga");
            $('[type="radio"]').prop('checked', false);
            $('.element-group.images').removeClass('active');
        });

        $('body').css('cursor', 'auto');
        $('body').removeClass('cp');

        $('#decision_form_nazwa_marki').change(function() {

            // if (Cookie.read("_zmiana_nazwy_marki") === "tak") {
            //     Debug.info("Zmiena nazwy marki już była. Bez informacji doradzcy");
            // } else {
            //     Cookie.write("_zmiana_nazwy_marki", "tak");
            Adviser.set(__("zmiana_nazwy_marki"), {'position': 'left'});
            // }

        });

        var Comics1 = new Comics();
    },
    loadBeforeAjax: function() {
        if ($('.modal.fade.in').length > 0 && $('.modal-spinner').length > 0) {
            $('.modal-spinner').show();
        } else if ($('.global-spinner').length > 0) {
            $('.global-spinner').show();
        } else {
            $('html').spin();
        }

        NoticeCenter.hideNotice();

        Cookie.write('timestamp', CoreTimer.tabTimestamp(), {duration: 1, secure: false});

        //$('.modal').modal('hide');
        //$('.modal-2').modal('hide');

        Debug.info("[AjaxLoader] Wykonuję funkcje przed wykonaniem AJAX {" + CoreTimer.timestamp() + "}");
    }
});


var AbsurdityDecisions = new Array(); 