var Helper = new Class({
    initialize: function() {

    }
}).extend({
    checkMusic: function(music) {

        Debug.info("[Helper] Sprawdzam muzyke");

        if ($('audio').length && $('audio source').attr('src') != '/files/music/0' + music + '.mp3') {
            // Zmiana nic nie daje, trzeba przeladowac strone
            $('audio source').attr('src', '/files/music/0' + music + '.mp3');
        }
    },
    setScroll: function() {

        Debug.info("[Helper] Ustawiono scrollbar");

//        $('[scrollarea="true"]').mCustomScrollbar("destroy");

        $('[scrollarea="true"]').mCustomScrollbar({
            scrollInertia: 250,
            scrollButtons: {
                enable: true
            }
        });

        if ($('#raportFinansowy').length) {
            Debug.info("[Helper] Ustawiono scrollbar poziomy");
            $('#raportFinansowy .mCSB_container').mCustomScrollbar({
                horizontalScroll: true,
                advanced: {
                    autoExpandHorizontalScroll: Boolean
                }
            });
        }

    },
    updateScroll: function() {

        Debug.info("[Helper] Update scrollbar");
//        $('[scrollarea="true"]').mCustomScrollbar("destroy");
//                $('[scrollarea="true"]').mCustomScrollbar({
//            scrollInertia: 250,
//            scrollButtons: {
//                enable: true
//            }
//        });
//      
//        Helper.setScroll(); 
        $('[scrollarea="true"]').mCustomScrollbar("update");

        if ($('#raportFinansowy').length) {
            Debug.info("[Helper] Update scrollbar poziomy");
            $('#raportFinansowy .mCSB_container').mCustomScrollbar("update");
        }

    },
    isNumber: function(o) {

        return !isNaN(o - 0) && o !== null && o !== "" && o !== false;
    },
    widgetClick: function(name, id, that) {

        $('[name="' + name + '"]').prop('checked', false);

        that.parent().find('.element-group').removeClass('active');
        that.addClass('active');

        $('#' + id).prop('checked', true);
        $('#' + id).first().change();

        return false;
    },
    numberFormat: function(number, decimals, dec_point, thousands_sep) {

        number = (number + '').replace(/[^0-9+\-Ee.]/g, '');

        var n = !isFinite(+number) ? 0 : +number,
                prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
                sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
                dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
                s = '',
                toFixedFix = function(n, prec) {
                    var k = Math.pow(10, prec);
                    return '' + Math.round(n * k) / k;
                };

        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');

        if (s[0].length > 3) {
            s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }

        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }

        return s.join(dec);
    },
    formatMoneyValue: function(value) {
        return Helper.numberFormat(value, 2, ',', ' ') + ' PLN';
    },
    setPopupSize: function() {
        var popupPosition = $('#buildingModal').position();
        var windowHeight = $(window).height();

        if (popupPosition != undefined && isset(popupPosition.top)) {
            Debug.info("[Helper] Ustawiam popup size na " + (windowHeight - 2 * popupPosition.top - 185));
            $('[scrollarea="true"]').height(windowHeight - 2 * popupPosition.top - 185);
        } else {
            Debug.info("[Helper] Ustawiam popup size 2 na " + (windowHeight - 185));
            $('[scrollarea="true"]').height(windowHeight - 185);
        }
    }
});

// WYKONANE BEZPOŚREDNIO PO WCZYTANIU STRONY //

$(document).ready(function() {
    $("html").attr('Browser', Browser.version);
    $("body").attr('BrowserName', Browser.name);
//  $("body").attr('BrowserEngineVersion',Browser.Engine.version);

    if ($('.modal-2')) {
        $('.modal-2').modal();
    }

    if ($('.modal')) {
        $('.modal').modal();
    }

    if (AppConfig.helpPopover) {
        $('[tooltip="true"]').tooltip({html: true});
    }

    try {
        if (isset(JavaScriptData)) {
            Debug.info('[JavaScriptData] Dane w PostBack');
            Object.each(JavaScriptData.Components, function(value, key) {
                JsRequest.parseComponent(key, value);
            });
        }
    } catch (e) {
        Debug.warning(e);
    }

    Helper.setScroll();

    if (Routing.generate("panelGry_gameController") === window.location.pathname) {
        var files = {
            Map: Config.rootPath + "/app/modules/engine/loader.js"
        }

        if (AppConfig.loadMap) {
            AutoLoad.loader(files, 0);
        } else {
            $(window).load(function() {
                $("#spinner").css({'display': 'none'});
                $("#spinner").remove();
            });
        }
    } else {
        $(window).load(function() {
            $("#spinner").css({'display': 'none'});
            $("#spinner").remove();
        });
    }

    if (Browser.ie8) {
        $(window).load(function() {
            $("#spinner").css({'display': 'none'});
            $("#spinner").remove();
        });
    }

    $('#decision_form_nazwa_marki').change(function() {
        Adviser.set(__("zmiana_nazwy_marki"), {'position': 'left'});
    });

    if (!AppConfig.sfWebDebug) {
        $('#sfWebDebug').remove();
    }
});


$(window).resize(function() {
    Helper.setPopupSize();
});

/**
 * Historia wykonywanych requestów po stronie przeglądarki. 
 * 
 * @type @exp;Request@call;Queue
 */
var RequestHistory = new Request.Queue({
    onComplete: function(name, instance, text, xml) {

    }
});
