/**
 * Klasa bazowa zawierająca metody do zarządzania Budynkami.
 *
 * @package     sfJSPlugin
 * @subpackage  buildings/base

 * @version     0.1-DEV
 * @type {Class}
 */
var Building = new Class({
  id: "#Buildings",
  initialize: function() {

  },
}).extend({
  setHtml: function(html) {
    $('#Buildings').html(unescape(html));
  },
  getBuilding: function(name) {
    buildingRequest.options.url = Routing.generate('panelGry_building', {'building': name});
    Debug.info("[Building] Trasa : " + buildingRequest.options.url);

    if (buildingRequest.isRunning())
    {
      Debug.info("[Building] Request already running");
    } else {
      RequestHistory.addRequest(jQuery.extend({}, buildingRequest));
      buildingRequest.send();

      Debug.info("[Building] Request started");
    }
  }, 
  getStatus: function(building){
    
    if (isset(GameData.buildings[building])){
      return GameData.buildings[building]; 
    }
    else {
      Debug.error("Nie ma budynku o podanej nazwie : " + building);
    }
    
  },
});

var buildingRequest = new Request.JSON({
  evalScripts: true,
  method: 'get',
  onRequest: function() {
    AjaxLoader.loadBeforeAjax();
  },
  onSuccess: function(responseJSON, responseText) {

    if (isset(responseJSON.HTML)) {
      $('#modalContainer').html(responseJSON.HTML.value);
    } 
    
    Object.each(responseJSON.Components, function(value, key) {
      JsRequest.parseComponent(key, value);
    });

    AjaxLoader.loadAfterAjax();
  },
  onFailure: function() {
    $('.modal-spinner').hide();
    $('.global-spinner').hide();
    $('.modal-backdrop').remove();
    NoticeCenter.ajaxError(); 
  }
});