/**
 * 
 * @type Class
 */
var CometClient = new Class({
  initialize: function() {

    if (Config.debug)
      PushStream.LOG_LEVEL = 'debug';

    Debug.info("[COMET {hostname}]: " + window.location.hostname);
    Debug.info("[COMET {port} || {Default : 80 }]: " + window.location.port);

    var PushStreamClient = new PushStream({
      host: window.location.hostname,
      port: window.location.port,
      modes: "websocket|eventsource|stream"
    });

    PushStreamClient._onmessage = this._manageEvent;
    PushStreamClient.onstatuschange = this._statuschanged;

    this._connect(PushStreamClient);
  },
  _manageEvent: function(Data) {
    
    Debug.info('[CometClient] JSON DATA');
    Debug.object(Data);

    if (Data.timestamp !== CoreTimer.tabTimestamp() && Data.map_change){
      Debug.info("Zmiany w mapie, reload strony"); 
      window.location.reload();
    }
    
    if (Data.timestamp !== CoreTimer.tabTimestamp() && Data.reload){
      ControllerRequest.options.url = Routing.generate('panelGry_building', {'building': 'hotel'});
      ControllerRequest.send();
    } else {
      Debug.info("[CometClient] Odpowiedź zwrotna, brak reakcji."); 
    }
    
  },
  _statuschanged: function(state) {
    if (state == PushStream.CONNECTING) {
      Debug.warning('[COMET] Status połączenia: CONNECTING');
    }
    else if (state == PushStream.OPEN) {
      Debug.info('[COMET] Status połączenia: OPEN');
    } else {
      Debug.error('[COMET] Status połączenia: CLOSED');
    }
  },
  _connect: function(PushStreamClient, channel) {
    PushStreamClient.removeAllChannels();

    try {
      PushStreamClient.addChannel(GameData.channel);
      PushStreamClient.connect();
    } catch (e) {
//      alert(e)
      Debug.error(e);
    }
  }
});

var ControllerRequest = new Request.JSON({
  evalScripts: true,
  method: 'get',
  onRequest: function() {
    $('html').spin();

    Debug.info('[ControllerRequest] : Reload danych w grze : PROCESS');
  },
  onSuccess: function(responseJSON, responseText) {

    Object.each(responseJSON.Components, function(value, key) {
      JsRequest.parseComponent(key, value);
    });

    $('html').unspin();
    Debug.info('[ControllerRequest] : Reload danych w grze : SUCCESS');
  },
  onFailure: function() {
    $('html').unspin();
    Debug.info('[ControllerRequest] : Reload danych w grze : FAIL');
  }
});


$(document).ready(function() {

  if (AppConfig.commetClient){
    document.body.onbeforeunload = function() {
      // Zrobić dla całości 
      PushStreamManager.getLast().disconnect();
    }

    document.body.onload = function() {
      var HttpPush = new CometClient();
    }
  }
});