/**
 * Klasa zawierająca metody do komponentem decyzji. 
 *
 * @package     sfJSPlugin
 * @subpackage  decisions

 * @version     0.1-DEV
 * @type {Class}
 */
var decisionRequest = new Request({
  method: 'get',
  onRequest: function() {
    AjaxLoader.loadBeforeAjax();
  },
  onSuccess: function(responseText) {
    $('#modalContainer').html(responseText);
    AjaxLoader.loadAfterAjax();
  },
  onFailure: function() {
    $('html').unspin();
    NoticeCenter.ajaxError(); 
  }
});


var Decisions = new Class({
  id: "#Decisions",
  initialize: function(id) {

    if (isset(id)) {
      this.id = id;
    }
  },
  getDecisionListModal: function(element) {

    decisionRequest.options.url = Routing.generate('decision_list');

    if (decisionRequest.isRunning())
    {
      Debug.info("[Decisions] Request already running");
    }
    else {
      decisionRequest.send();
      RequestHistory.addRequest(jQuery.extend({}, decisionRequest));

      Debug.info("[Decisions] Request started");
    }
  }

});

var decisions = new Decisions();