/**
 * Client Iteam,
 *
 * @package     sfJSPlugin
 * @subpackage  map/gameClasses

 * @version     0.1-DEV
 * @type {Class}
 */

var ClientItem = IgeEntity.extend({
	classId: 'ClientItem',

	init: function (tileX, tileY, tileWidth, tileHeight) {
		IgeEntity.prototype.init.call(this);

		this.data('tileX', tileX)
			.data('tileY', tileY)
			.data('tileWidth', tileWidth)
			.data('tileHeight', tileHeight);
	},

	place: function () {
		this.occupyTile(
			this.data('tileX'),
			this.data('tileY'),
			this.data('tileWidth'),
			this.data('tileHeight')
		);

		this.data('placed', true);

		return this;
	},

	moveTo: function (tileX, tileY) {
		if (this.data('placed')) {
			this.unOccupyTile(
				this.data('tileX'),
				this.data('tileY'),
				this.data('tileWidth'),
				this.data('tileHeight')
			);

			this.data('tileX', tileX)
				.data('tileY', tileY);

			this.occupyTile(
				this.data('tileX'),
				this.data('tileY'),
				this.data('tileWidth'),
				this.data('tileHeight')
			);

			this.translateToTile(
				this.data('tileX'),
				this.data('tileY')
			);
		}

		return this;
	},

	destroy: function () {
		if (this.data('placed')) {
			this.unOccupyTile(
				this.data('tileX'),
				this.data('tileY'),
				this.data('tileWidth'),
				this.data('tileHeight')
			);

			this.data('placed', false);
		}
		IgeEntity.prototype.destroy.call(this);
	}
});

if (typeof(module) !== 'undefined' && typeof(module.exports) !== 'undefined') { module.exports = ClientItem; }