/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Bank = {
    Bank: IgeEntity.extend({
        classId: 'Bank',
        name: 'bank',
        init: function(parent, tileX, tileY) {
            IgeEntity.prototype.init.call(this);
            var self = this;

            this.isometric(true)
                    .mount(parent)
                    .size3d(parent._tileWidth + 30, parent._tileHeight + 20, 30)
                    .translateToTile(tileX, tileY, 0)

                    .mouseOver(function() {
                        this.drawBounds(true);
                        this.drawBoundsData(true);
                         
                        if (Building.getStatus(this.name) != 2) {
                            this.imageEntity.texture(texture_hover);
                            $('body').addClass('cp');
                        }
                    })

                    .mouseOut(function() {
                        this.drawBounds(false);
                        this.drawBoundsData(false);
                        
                        if (Building.getStatus(this.name) != 2) {
                            this.imageEntity.texture(texture);
                            $('body').removeClass('cp');
                        }
                    })
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .occupyTile(tileX, tileY, 1, 1);

            var texture = ige.client.gameTexture.b.base,
                    halfImageHeight = texture.image.height / 2,
                    quarterImageWidth = texture.image.width / 4,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

            var texture_hover = ige.client.gameTexture.b.hover;

            this.imageEntity = new IgeEntity()
                    .texture(texture)
                    .dimensionsFromCell()
                    .scaleTo(imageScale, imageScale, 1)
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(0, yPos, 0)
                    .mount(this);
        },
        _mouseUp: function(event, x, y, button) {
            if (Building.getStatus(this.name) != 2)
                Menu.getBuildingModal(this.name);
        },
    }),
}