/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var HotelSuburbs = {
  HotelSuburbs: IgeEntity.extend({
    classId: 'HotelSuburbs',
    name: 'hotel',
    init: function(parent, tileX, tileY) {

      IgeEntity.prototype.init.call(this, tileX, tileY, 2, 2);

      var self = this;

      this.data('base', 'se')
              .data('floors', 0)
              .data('crane', 'se')
              .data('baseRef', null)
              .data('floorRef', [])
              .data('craneRef', null);

      this.isometric(true)
              .isometricMounts(true)
              .size3d(1 * parent._tileWidth, 1 * parent._tileHeight, 8.25 * (parent._tileWidth / 40))
              .mouseOver(function() {
                this.highlight(true);
                this.drawBounds(true);
                this.drawBoundsData(true);

                if (Building.getStatus(this.name) != 2) {
                  $('body').addClass('cp');
                }
              })
              .mouseOut(function() {
                this.highlight(false);
                this.drawBounds(false);
                this.drawBoundsData(false);

                if (Building.getStatus(this.name) != 2) {
                  $('body').removeClass('cp');
                }
              })
              .drawBounds(true)
              .drawBoundsData(true)
              .opacity(1)
              .mount(parent)
              .translateToTile((tileX) + 0.5, (tileY) + 0.5, 0)
              .occupyTile(tileX, tileY, 1, 1);

      this.data('baseRef', new IgeEntity()
              .isometric(true)
              .mount(this)
              .size3d(1 * parent._tileWidth, 1 * parent._tileHeight, 8.25 * (parent._tileWidth / 40))
              .translateTo(40, -20, 1)
              .anchor(0, -1.6 * (parent._tileWidth / 40))
              .category(this.name)
              .mouseOver(function() {
                this.highlight(true);
                this.drawBounds(true);
                this.drawBoundsData(true);
              })
              .mouseOut(function() {
                this.highlight(false);
                this.drawBounds(false);
                this.drawBoundsData(false);
              })
              .drawBounds(false)
              .drawBoundsData(false)
              );


      new IgeEntity()
              .mouseOver(function() {
                this.texture(ige.client.gameTexture.hp['base.seh']);
              })
              .mouseOut(function() {
                this.texture(ige.client.gameTexture.hp['base.se']);
              })
              .texture(ige.client.gameTexture.hp['base.se'])
              .width(ige.client.gameTexture.hp['base.se'].image.width * 0.265 * (parent._tileWidth / 40))
              .height(ige.client.gameTexture.hp['base.se'].image.height * 0.265 * (parent._tileWidth / 40))

              .drawBounds(false)
              .drawBoundsData(false)
              .mount(this.data('baseRef'));


      this.floors(GameData.floors);
      this.setCrane(GameData.crane);
      this.addName();
    },
    highlight: function(bool) {
      this._children.each(function(entity) {
        entity.highlight(bool);
      });
    },
    base: function(val) {
      this.data('base', val);
    },
    floors: function(val) {
      var floorDiff;
      
      if (this.data('floors') == 0) {
        this.addLastFloor();
      }

      if (val >= 10) {
        return;
      }

      if (val === this.data('floors')) {
        return;
      }

      if (val > this.data('floors')) {
        floorDiff = val - this.data('floors');

        this.addFloors(floorDiff);
      }

      if (val < this.data('floors')) {
        floorDiff = this.data('floors') - val;

        this.removeFloors(floorDiff);
      }

      return this;
    },
    addFloors: function(numFloors) {
      this.removeFloors(1);
      var floor, floorCount = this.data('floors');

      if (floorCount >= 10) {
        return;
      }

      for (floor = floorCount; floor < floorCount + (numFloors); floor++) {

        this.data('floorRef')[floor] = new IgeEntity()
                .isometric(true)
                .layer(floor)
                .mount(this)
                .size3d(1 * this._parent._tileWidth, 1 * this._parent._tileHeight, 8.5 * (this._parent._tileWidth / 40))
                .translateTo(0, 0, 12 * (floor + 1) * (this._parent._tileWidth / 40))
                .anchor(0, -1.6 * (this._parent._tileWidth / 40))
                .category(this.name)
                .mouseOver(function() {
                  this.highlight(true);
                  this.drawBounds(true);
                  this.drawBoundsData(true);
                })
                .mouseOut(function() {
                  this.highlight(false);
                  this.drawBounds(false);
                  this.drawBoundsData(false);
                })
                .drawBounds(false)
                .drawBoundsData(false);

        new IgeEntity()
                .mouseOver(function() {
                  this.texture(ige.client.gameTexture.hp['stacker.seh']);
                })
                .mouseOut(function() {
                  this.texture(ige.client.gameTexture.hp['stacker.se']);
                })
                .texture(ige.client.gameTexture.hp['stacker.se'])
                .width(ige.client.gameTexture.hp['stacker.se'].image.width * 0.265 * (this._parent._tileWidth / 40))
                .height(ige.client.gameTexture.hp['stacker.se'].image.height * 0.265 * (this._parent._tileHeight / 40))
                .drawBounds(false)
                .drawBoundsData(false)
                .mount(this.data('floorRef')[floor]);
      }

      this.data('floors', floorCount + numFloors);

      if (this.data('craneRef')) {
        this.data('craneRef')
                .translateTo(
                        0,
                        0,
                        12.5 * (this.data('floors') + 1)
                        )
                .layer(this.data('floors') + 1);
      }

      this.size3d(
              this._geometry.x,
              this._geometry.y,
              6.25 + (this.data('floors') * 12.5 * (this._parent._tileWidth / 40))
              );

      this.addLastFloor();

      return this;
    },
    addLastFloor: function() {
      var floor, floorCount = this.data('floors');
      floor = floorCount;

      if (floorCount >= 10) {
        return;
      }

      this.data('floorRef')[floor] = new IgeEntity()
              .isometric(true)
              .layer(floor)
              .mount(this)
              .size3d(1 * this._parent._tileWidth, 1 * this._parent._tileHeight, 8.5 * (this._parent._tileWidth / 40))
              .translateTo(0, 0, 12 * (floor + 1) * (this._parent._tileWidth / 40) + 5)
              .anchor(0, -1.6 * (this._parent._tileWidth / 40))
              .category(this.name)
              .mouseOver(function() {
                this.highlight(true);
                this.drawBounds(true);
                this.drawBoundsData(true);
              })
              .mouseOut(function() {
                this.highlight(false);
                this.drawBounds(false);
                this.drawBoundsData(false);
              })
              .drawBounds(false)
              .drawBoundsData(false);

      new IgeEntity()
              .mouseOver(function() {
                this.texture(ige.client.gameTexture.hp['head.seh']);
              })
              .mouseOut(function() {
                this.texture(ige.client.gameTexture.hp['head.se']);
              })
              .texture(ige.client.gameTexture.hp['head.se'])
              .width(ige.client.gameTexture.hp['head.se'].image.width * 0.265 * (this._parent._tileWidth / 40))
              .height(ige.client.gameTexture.hp['head.se'].image.height * 0.265 * (this._parent._tileHeight / 40))
              .drawBounds(false)
              .drawBoundsData(false)
              .mount(this.data('floorRef')[floor]);

      this.data('floors', floorCount + 1);

      if (this.data('craneRef')) {
        this.data('craneRef')
                .translateTo(
                        0,
                        0,
                        12.5 * (this.data('floors') + 1)
                        )
                .layer(this.data('floors') + 1);
      }

      this.size3d(
              this._geometry.x,
              this._geometry.y,
              6.25 + (this.data('floors') * 12.5 * (this._parent._tileWidth / 40))
              );

      return this;
    },
    removeFloors: function(numFloors) {
      var floor;

      if (this.data('floors') > 0) {

        if (this.data('floors') - numFloors < 0) {
          numFloors = this.data('floors');
        }

        for (floor = 1; floor <= numFloors; floor++) {
          this.data('floorRef')[this.data('floors') - floor].destroy();
          delete this.data('floorRef')[this.data('floors') - floor];
        }

        this._data.floors -= numFloors;

        this.size3d(
                this._geometry.x,
                this._geometry.y,
                6.25 + (this.data('floors') * 12.5 * (this._parent._tileWidth / 40))
                );
      }

      if (this.data('craneRef')) {
        this.data('craneRef')
                .translateTo(
                        0,
                        0,
                        12.5 * (this.data('floors') + 1)
                        );
      }

      return this;
    },
    crane: function(val) {
      if (val === this.data('crane')) {
        return;
      }

      this.removeCrane();

      if (val) {
        this.addCrane(val);
      }

      return this;
    },
    setCrane: function(val) {

      Debug.info('[setCrane] :' + val);
      if (val == 1) {
        this.addCrane('se');
      } else {
        this.removeCrane();
      }
    },
    addCrane: function(val) {

      if (!this.data('craneRef')) {

        var levelTextureId,
                anchorX,
                anchorY;

        this.data('crane', val);

        if (val === 'se') {
          levelTextureId = 'se';
          anchorX = 25;
          anchorY = 0;
        }
        if (val === 'sw') {
          levelTextureId = 'sw';
          anchorX = -25;
          anchorY = 0;
        }
        if (val === 'ne') {
          levelTextureId = 'ne';
          anchorX = 25;
          anchorY = -10;
        }
        if (val === 'nw') {
          levelTextureId = 'nw';
          anchorX = -25;
          anchorY = -10;
        }

        this.data('craneRef', new IgeEntity()
                .isometric(true)
                .layer(this.data('floors') + 1)
                .mount(this)
                .size3d(20, 20, 55)
                .translateTo(
                        0,
                        0,
                        12.5 * (this.data('floors') + 1)
                        )
                .category(this.name)
                .mouseOver(function() {
                  this.highlight(true);
                  this.drawBounds(true);
                  this.drawBoundsData(true);
                })
                .mouseOut(function() {
                  this.highlight(false);
                  this.drawBounds(false);
                  this.drawBoundsData(false);
                })
                .drawBounds(false)
                .drawBoundsData(false)
                );

        new IgeEntity()
                .texture(ige.client.gameTexture.crane[levelTextureId])
                .width(ige.client.gameTexture.crane[levelTextureId].image.width * 0.265 * (this._parent._tileWidth / 40))
                .height(ige.client.gameTexture.crane[levelTextureId].image.height * 0.265 * (this._parent._tileHeight / 40))
                .anchor(-anchorX, -anchorY)
                .drawBounds(false)
                .drawBoundsData(false)
                .mount(this.data('craneRef'));
      }

      return this;
    },
    removeCrane: function() {
      if (this.data('craneRef')) {
        this.data('craneRef').destroy();
        delete this._data.craneRef;
        delete this._data.crane;
      }

      return this;
    },
    build: function(floors) {
      var self = this;
      this.data('buildFloors', floors);
      setTimeout(function() {
        self._buildTick();
      }, 1000);
    },
    addName: function(name) {

      if (!isset(name)) {
        var name = GameData.hotelName;
      }

      if (isset(this.hotelName))
        this.hotelName.unMount();

      this.hotelName = new IgeFontEntity()
              .depth(9)
              .text(name)
              .width(700)
              .height(700)
              .textAlignX(1)
              .textAlignY(0)
              .colorOverlay('#000000')
              .borderRadius(0)
              .nativeFont('small-caps bold 14px arial')
              .nativeStroke(1)
              .overflow(false)
              .nativeStrokeColor('#FFFFFF')
              .opacity(0.8)
              .center(-70)
              .middle(-65)
              .mount(this.data('baseRef'));

    },
    _buildTick: function() {
      var currentFloors = this.data('floors'),
              buildFloors = this.data('buildFloors'),
              self = this;

      if (currentFloors < buildFloors - 1) {
        this.addFloors(1);

        switch (this.data('crane')) {
          case 'se':
            this.crane('sw');
            break;

          case 'sw':
            this.crane('nw');
            break;

          case 'nw':
            this.crane('ne');
            break;

          case 'ne':
            this.crane('se');
            break;
        }

        setTimeout(function() {
          self._buildTick();
        }, 1000);
      } else {
//        this.addFloors(1);
        this.addLastFloor();
//        this.removeCrane();
      }
    },
    _mouseUp: function(event, x, y, button) {
      if (Building.getStatus(this.name) != 2)
        Menu.getBuildingModal(this.name);
    }
  })
}