
var LaborOffice = {
  LaborOffice: IgeEntity.extend({
    classId: 'LaborOffice',
    name: 'urzad_pracy', 
    init: function(parent, tileX, tileY) {
      IgeEntity.prototype.init.call(this);
      var self = this;

      this.isometric(true)
              .mount(parent)

              // x / y /wysokosc
              .size3d(60, 150, 90)
              .translateToTile(tileX, tileY, 0)

              .mouseOver(function() {
                this.drawBounds(true);
                this.drawBoundsData(true);

                if (Building.getStatus(this.name) != 2) {
//                  this.imageEntity.highlight(true);
                  this.imageEntity.texture(texture_hover);
                  $('body').addClass('cp');
                } 
              })

              .mouseOut(function() {
                this.drawBounds(false);
                this.drawBoundsData(false);

                if (Building.getStatus(this.name) != 2) {
//                  this.imageEntity.highlight(false);
                  this.imageEntity.texture(texture);
                  $('body').removeClass('cp');
                }
              })

              .drawBounds(false)
              .drawBoundsData(false)
              .occupyTile(tileX, tileY, 1, 1);

      var texture = ige.client.gameTexture.lo.base,
              halfImageHeight = texture.image.height / 2,
              quarterImageWidth = texture.image.width / 4,
              imageScale = 1,
              yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

      var texture_hover = ige.client.gameTexture.lo.hover;

      this.imageEntity = new IgeEntity()
              .texture(texture)
              .dimensionsFromCell()
              .scaleTo(imageScale, imageScale, 1)
              .drawBounds(false)
              .drawBoundsData(false)
              .translateTo(45, 0, 0)
              .mount(this);
    },
    _mouseUp: function(event, x, y, button) {
      if (Building.getStatus(this.name) != 2)
        Menu.getBuildingModal(this.name);
    },
  }),
}