/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Boats = {
  Boat: IgeEntity.extend({
    classId: 'Boat',
    
    init: function(parent, tileX, tileY, type) {
      IgeEntity.prototype.init.call(this);
      var self = this;
      
      this.isometric(true)
              .mount(parent)
              .size3d( parent._tileWidth, parent._tileHeight, 30)
              .translateToTile(tileX, tileY, 0)
              .mouseOver(function() {
                this.drawBounds(true);
                this.drawBoundsData(true);
              })

              .mouseOut(function() {
                this.drawBounds(false);
                this.drawBoundsData(false);
              })
              .drawBounds(false)
              .drawBoundsData(false)
              .occupyTile(tileX, tileY, 1, 1);

     switch(type){
       case 1: 
         var texture = ige.client.gameTexture.boat[1]; 
         break;
       case 2: 
         var texture = ige.client.gameTexture.boat[2]; 
         break;
       case 3: 
         var texture = ige.client.gameTexture.boat[3]; 
         break;
       case 4: 
         var texture = ige.client.gameTexture.boat[4]; 
         break;
       case 5: 
         var texture = ige.client.gameTexture.boat[5]; 
         break;
       case 6: 
         var texture = ige.client.gameTexture.boat[6]; 
         break;
       case 7: 
         var texture = ige.client.gameTexture.boat[7]; 
         break;
       case 8: 
         var texture = ige.client.gameTexture.boat[8]; 
         break;
       default:
         Debug.error('[Boats] type "'+type+'" is undefined'); 
         break;
     }

      var    halfImageHeight = texture.image.height / 2,
              quarterImageWidth = texture.image.width / 4,
              imageScale = 1,
              yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

      this.imageEntity = new IgeEntity()
              .texture(texture)
              .dimensionsFromCell()
              .scaleTo(imageScale, imageScale, 1)
              .drawBounds(false)
              .drawBoundsData(false)
              .translateTo(0, yPos, 0)
              .mount(this);

    },
    _mouseUp: function(event, x, y, button) {

    },
    animate: function(type, speed) {
      
      if (!isset(speed)) 
        var speed = 1;

      switch (type)
      {
        case 1:
          this._translate.tween()
                  .stepBy({
                    x: 30,
                    y: 30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: -30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: 130
                  }, 19500 * speed, 'inOutSine')
                  .stepBy({
                    x: 60,
                    y: 60
                  }, 5500 * speed, 'inOutSine')
                  .stepBy({
                    x: -60,
                    y: -60
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 30,
                    y: -130
                  }, 29500 * speed, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 2:
          this._translate.tween()
                  .stepBy({
                    x: 30,
                    y: 30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: -30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: 130
                  }, 19500 * speed, 'inOutSine')
                  .stepBy({
                    x: 60,
                    y: 60
                  }, 5500 * speed, 'inOutSine')
                  .stepBy({
                    x: -60,
                    y: -60
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 30,
                    y: -130
                  }, 29500 * speed, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
        case 3:
          this._translate.tween()
                  .stepBy({
                    x: 60,
                    y: 60
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -60,
                    y: -60
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: 130
                  }, 19500 * speed, 'inOutSine')
                  .stepBy({
                    x: 50,
                    y: 50
                  }, 5500 * speed, 'inOutSine')
                  .stepBy({
                    x: -50,
                    y: -50
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 30,
                    y: -130
                  }, 29500 * speed, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 4:
          this._translate.tween()
                  .stepBy({
                    x: -30,
                    y: -30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: 30,
                    y: 30
                  }, 2500 * speed, 'inOutSine')
                  .stepBy({
                    x: -30,
                    y: 230
                  }, 9500 * speed, 'inOutSine')
                  .stepBy({
                    x: 60,
                    y: 60
                  }, 4500 * speed, 'inOutSine')
                  .stepBy({
                    x: -60,
                    y: -60
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 30,
                    y: -230
                  }, 29500 * speed, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;

        default:
          Debug.error("Undefinied animate type : " + type); 
      }
    }
  }),
}