/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Buildings = {
    BackgroundBuildings: IgeEntity.extend({
        classId: 'BackgroundBuildings',
        init: function(parent, tileX, tileY) {
            IgeEntity.prototype.init.call(this);
            var self = this;

            this.isometric(true)
                    .mount(parent)
                    .depth(-2)
//              .noAabb(true)
//              .depth(-1)
//              .overflow(false)
//              .tileHeight(2000)
//              .tileWidth(4000)
//              .ignoreCameraComposite(true)
                    .size3d(4000, 2000, 1)
                    .translateToTile(tileX, tileY, 0)
//              .mouseOver(function() {
//        this.drawBounds(false);
//        this.drawBoundsData(false);
//      })
//              .mouseOut(function() {
//        this.drawBounds(false);
//        this.drawBoundsData(false);
//      })
                    .drawBounds(false)
//              .isometricMounts(false)
                    .drawBoundsData(false)
                    .occupyTile(0, 100, 1, 1);

            var texture = ige.client.gameTexture.bg.buildings,
                    halfImageHeight = texture.image.height,
                    quarterImageWidth = texture.image.width,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

            this.imageEntity = new IgeEntity()
                    .texture(texture)
//              .isometricMounts(false)
                    .dimensionsFromTexture()
                    .scaleTo(imageScale, imageScale, 1)
//              .drawBounds(true)
//              .drawBoundsData(true)
                    .translateTo(0, 0, 0)
                    .mount(this);
        },
        _mouseUp: function(event, x, y, button) {
        },
    }),
    Buildings: IgeEntity.extend({
        classId: 'Buildings',
        init: function(parent, tileX, tileY) {
            IgeEntity.prototype.init.call(this);
            var self = this;

            this.isometric(true)
                    .mount(parent)
                    .size3d(3.5 * parent._tileWidth, 2 * parent._tileHeight, 30)
                    .translateToTile(tileX, tileY, 0)

                    .mouseOver(function() {
                        // this.drawBounds(false);
                        // this.drawBoundsData(false);
                    })

                    .mouseOut(function() {
                        // this.drawBounds(false);
                        // this.drawBoundsData(false);
                    })

                    .drawBounds(false)
                    .drawBoundsData(false)
                    .occupyTile(tileX, tileY, 1, 1);

            var texture = ige.client.gameTexture.budynki,
                    halfImageHeight = texture.image.height / 2,
                    quarterImageWidth = texture.image.width / 4,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

            this.imageEntity =
                    new IgeEntity()
                    .texture(texture)
                    .dimensionsFromCell()
                    .scaleTo(imageScale, imageScale, 1)
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(0, yPos, 0)
                    .mount(this);
        },
        _mouseUp: function(event, x, y, button) {
        },
    }),
}