/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Cars = {
  Car: IgeEntity.extend({
    classId: 'Car',
    init: function(parent, tileX, tileY, type) {
      IgeEntity.prototype.init.call(this);
      var self = this;

      this.isometric(true)
              .mount(parent)
              .size3d(parent._tileWidth, parent._tileHeight, 30)
              .translateToTile(tileX, tileY, 0)
              .drawBounds(false)
              .drawBoundsData(false)
              .occupyTile(tileX, tileY, 1, 1);

      switch (type) {
        case 1:
          var texture = ige.client.gameTexture.car[1];
          break;
        case 2:
          var texture = ige.client.gameTexture.car[2];
          break;
        case 3:
          var texture = ige.client.gameTexture.car[3];
          break;
        case 4:
          var texture = ige.client.gameTexture.car[4];
          break;
        case 5:
          var texture = ige.client.gameTexture.car[5];
          break;
        case 6:
          var texture = ige.client.gameTexture.bus[1];
          break;
        case 7:
          var texture = ige.client.gameTexture.bus[2];
          break;
        case 8:
          var texture = ige.client.gameTexture.car[6];
          break;
        case 9:
          var texture = ige.client.gameTexture.truck[1];
          break;
        case 10:
          var texture = ige.client.gameTexture.car[7];
          break;
        case 11:
          var texture = ige.client.gameTexture.car[8];
          break;
        case 12:
          var texture = ige.client.gameTexture.bus[3];
          break;
        case 13:
          var texture = ige.client.gameTexture.truck[2];
          break;
        case 14:
          var texture = ige.client.gameTexture.car[9];
          break;
        case 15:
          var texture = ige.client.gameTexture.car[10];
          break;
        case 16:
          var texture = ige.client.gameTexture.bus[4];
          break;
        default:
          Debug.error("Undefined car type : " + type);
          break;
      }

      var halfImageHeight = texture.image.height / 2,
              quarterImageWidth = texture.image.width / 4,
              imageScale = 1,
              yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

      this.imageEntity = new IgeEntity()
              .texture(texture)
              .mouseOver(function() {
                this.drawBounds(true);
                this.drawBoundsData(true);
                
//                this._translate.tween().stop();
              })
              .mouseOut(function() {
                this.drawBounds(false);
                this.drawBoundsData(false);
                
//                this._translate.tween().start();
              })
              .drawBounds(false)
              .drawBoundsData(false)
      
              .dimensionsFromCell()
              .scaleTo(imageScale, imageScale, 1)
              .translateTo(0, yPos, 0)
              .mount(this);
    },
    _mouseUp: function(event, x, y, button) {

    },
    animate: function(type, speed) {

      if (!isset(speed))
        var speed = 1;

      switch (type) {
        case 1:
          this.imageEntity._translate.tween()
                  .stepBy({
                    x: 850,
                    y: -432
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 160,
                    y: 95
                  }, 6000 * speed, 'inOutSine')
                  .stepBy({
                    x: 270,
                    y: -130
                  }, 5500 * speed, 'inOutSine')
                  .stepBy({
                    x: -200,
                    y: -110
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 245,
                    y: -135
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -180,
                    y: -95
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -110,
                    y: 40
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: -360,
                    y: -170
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -420,
                    y: 214
                  }, 5500 * speed, 'inOutSine')
                  .stepBy({
                    x: 200,
                    y: 110
                  }, 4500 * speed, 'inOutSine')
                  .stepBy({
                    x: -845,
                    y: 430
                  }, 7500 * speed, 'inOutSine')
                  .stepBy({
                    x: 390,
                    y: 183
                  }, 0, 'inOutSine')

                  .repeatMode(1, -1)
                  .beforeStep(function() {

                  })
                  .start();
          break;

        case 2:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 850,
                    y: -432
                  }, 9500 * speed, 'inOutSine')
                  .stepBy({
                    x: -10,
                    y: -10
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -850,
                    y: 432
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 10,
                    y: 10
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 3:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 850,
                    y: -432
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -10,
                    y: -10
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -850,
                    y: 432
                  }, 12500, 'inOutSine')
                  .stepBy({
                    x: 10,
                    y: 10
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start()
          break;
        case 4:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2400,
                    y: 1200
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2400,
                    y: -1200
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 5:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 300,
                    y: 150
                  }, 2500, 'inOutSine')
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 99500, 'inOutSine')
                  .stepBy({
                    x: -300,
                    y: -150
                  }, 10500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 6:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;

        case 7:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 8:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 9:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 300,
                    y: 150
                  }, 2500, 'inOutSine')
                  .stepBy({
                    x: 0,
                    y: -30
                  }, 100, 'inOutSine')
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 52000, 'inOutSine')
                  .stepBy({
                    x: 0,
                    y: 30
                  }, 100, 'inOutSine')
                  .stepBy({
                    x: -300,
                    y: -150
                  }, 10500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 10:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 32500, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 11:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 5000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 22500, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')

                  .beforeStep(function() {
                  })

                  .repeatMode(1, -1)
                  .start();
          break;
        case 12:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 6000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 32500, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 13:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 13000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 42500, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 14:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 10350, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 42500, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 15:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 42500, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 16:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 5000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 22500, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 17:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 6000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 32500, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 18:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 10000, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 42500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 19:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 0,
                    y: 0
                  }, 10350, 'inOutSine')
                  .stepBy({
                    x: 3400,
                    y: -1728
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -15,
                    y: -15
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -3400,
                    y: 1728
                  }, 42500, 'inOutSine')
                  .stepBy({
                    x: 15,
                    y: 15
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 20:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 21:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 22:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 19500, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 0, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        case 23:
          this.imageEntity
                  ._translate.tween()
                  .stepBy({
                    x: 2000,
                    y: 1000
                  }, 0, 'inOutSine')
                  .stepBy({
                    x: -2000,
                    y: -1000
                  }, 29500, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;
        default:
          Debug.error("Undefined animate type : " + type);
      }

    }
  }),
}