/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Helicopters = {
  Helicopter: IgeEntity.extend({
    classId: 'Helicopter',
    init: function(parent, tileX, tileY, type) {
      IgeEntity.prototype.init.call(this);
      var self = this;

      this.isometric(true)
              .mount(parent)
              .size3d(parent._tileWidth, parent._tileHeight, 30)
              .translateToTile(tileX, tileY, 1)
              .mouseOver(function() {
                this.drawBounds(true);
                this.drawBoundsData(true);
              })

              .mouseOut(function() {
                this.drawBounds(false);
                this.drawBoundsData(false);
              })

              .drawBounds(false)
              .drawBoundsData(false)
              .occupyTile(tileX, tileY, 1, 1);


      switch (type) {
        case 'se':
          var texture = ige.client.gameTexture.helicopter['se'];
          break;
        default:
          Debug.error('[Helicopter] type "' + type + '" is undefined');
          break;
      }

      var halfImageHeight = texture.image.height / 2,
              quarterImageWidth = texture.image.width / 4,
              imageScale = 0.2,
              yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

      this.imageEntity = new IgeEntity()
              .texture(texture)
              .dimensionsFromCell()
              .scaleTo(imageScale, imageScale, 1)
              .drawBounds(false)
              .drawBoundsData(false)
              .translateTo(0, yPos, 0)

              .addComponent(IgeAnimationComponent)
              .animation.define('h', [1, 2, 3], 8, -1)
              .animation.select('h')
              .animation.start('h')
              .animation.setFps(15)
              .mount(this);
    },
    
    _mouseUp: function(event, x, y, button) {

    },
    animate: function(type, speed) {

      if (!isset(speed))
        var speed = 1;

      switch (type)
      {
        case 1:
          this._translate.tween()
                 .stepBy({
                    x: -2500,
                    y: -2500
                  }, 0 * speed, 'inOutSine')
                 .stepBy({
                    x: 2500,
                    y: 2500
                  }, 25000 * speed, 'inOutSine')
                 .stepBy({
                    x: 0,
                    y: 0
                  }, 10000 * speed, 'inOutSine')
                  .stepBy({
                    x: -250,
                    y: -250
                  }, 4500 * speed, 'inOutSine')
                  .stepBy({
                    x: 2500,
                    y: -2500
                  }, 25000 * speed, 'inOutSine')
                  .stepBy({
                    x: -2250,
                    y: 2750
                  }, 0 * speed, 'inOutSine')
                  .repeatMode(1, -1)
                  .beforeStep(function() {
                  })
                  .start();
          break;

        default:
          Debug.error("Undefinied animate type : " + type);
      }
    }
  }),
}