/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Overlays = {
    Overlay: IgeEntity.extend({
        classId: 'Overlay',
        init: function(parent, tileX, tileY) {
            var self = this;
            IgeEntity.prototype.init.call(this);

            this.isometric(true)
                    .depth(999)
                    .mount(parent)
                    .size3d(2 * parent._tileWidth, 2 * parent._tileHeight, 30)
                    .translateToTile(tileX, tileY, 0)
                    .mouseOver(function() {
                        this.drawBounds(false);
                        this.drawBoundsData(false);
                    })
                    .mouseOut(function() {
                        this.drawBounds(false);
                        this.drawBoundsData(false);
                    })
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(-483, 515, 1)
                    .occupyTile(tileX, tileY, 1, 1);

            var texture = ige.client.gameTexture.nakladka,
                    halfImageHeight = texture.image.height / 2,
                    quarterImageWidth = texture.image.width / 4,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

            this.imageEntity = new IgeEntity()
                    .texture(texture)
                    .dimensionsFromCell()
                    .scaleTo(imageScale, imageScale, 1)
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(-605, yPos - 300, 0)
                    .mount(this);
        },
        _mouseUp: function(event, x, y, button) {
        },
    }),
}