/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Train = {
    Train: IgeEntity.extend({
        classId: 'Train',
        init: function(parent, tileX, tileY) {
            IgeEntity.prototype.init.call(this);
            var self = this;

            this.isometric(true)
                    .mount(parent)
                    .size3d(330, 20, 30)
                    .translateToTile(tileX, tileY, 0)
                    .mouseOver(function() {
//        this.drawBounds(false);
//        this.drawBoundsData(false);
                    })
                    .mouseOut(function() {
//        this.drawBounds(false);
//        this.drawBoundsData(false);
                    })
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .occupyTile(tileX, tileY, 1, 1);

            var texture = ige.client.gameTexture.train,
                    halfImageHeight = texture.image.height / 2,
                    quarterImageWidth = texture.image.width / 4,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));


            this.imageEntity = new IgeEntity()
                    .texture(texture)
                    .dimensionsFromCell()
                    .scaleTo(imageScale, imageScale, 1)
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(0, yPos, 0)
                    .mount(this)

                    .addComponent(IgeAnimationComponent);
//              ._translate.tween()
//              .stopAll()
//              .properties({x: 1530, y: 780})
//              .duration(30000)
//              .start();

            this.imageEntity._translate.tween()
                    .stepBy({
                        x: -1125,
                        y: -550
                    }, 10000, 'inOutSine')
                    .stepBy({
                        x: 1125,
                        y: 550
                    }, 10000, 'inOutSine')
                    .stepBy({
                        x: 0,
                        y: 0
                    }, 5000, 'inOutSine')
                    .stepBy({
                        x: 3120,
                        y: 1540
                    }, 20000, 'inOutSine')
                    .stepBy({
                        x: -3120,
                        y: -1540
                    }, 11000, 'inOutSine')

                    .repeatMode(1, -1)
                    .beforeStep(function() {

                    })
                    .start();
        },
        _mouseUp: function(event, x, y, button) {
        },
    }),
}