/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


var Trees = {
    BackgroundTrees: IgeEntity.extend({
        classId: 'BackgroundTrees',
        init: function(parent, tileX, tileY) {
            IgeEntity.prototype.init.call(this);
            var self = this;

            this.isometric(true)
                    .mount(parent)
                    .depth(-1)
                    .size3d(4000, 2000, 1)
                    .translateToTile(tileX, tileY, 0)
                    .mouseOver(function() {
                        this.drawBounds(false);
                        this.drawBoundsData(false);
                    })
                    .mouseOut(function() {
                        this.drawBounds(false);
                        this.drawBoundsData(false);
                    })
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .occupyTile(0, 100, 1, 1);

            var texture = ige.client.gameTexture.bg.threes,
                    halfImageHeight = texture.image.height,
                    quarterImageWidth = texture.image.width,
                    imageScale = 1,
                    yPos = ((-halfImageHeight + quarterImageWidth) * imageScale) + (this._geometry.z2 + (this._geometry.z2 / 4));

            this.imageEntity =
                    new IgeEntity()
                    .texture(texture)
                    .dimensionsFromTexture()
                    .scaleTo(imageScale, imageScale, 1)
                    .drawBounds(false)
                    .drawBoundsData(false)
                    .translateTo(0, 0, 0)
                    .mount(this);
        },
        _mouseUp: function(event, x, y, button) {
        },
    }),
}