/**
 * Postać - kontener.
 *
 * @package     sfJSPlugin
 * @subpackage  map/gameClasses

 * @version     0.1-DEV
 * @type {Class}
 */
// Define our player character container classes
var CharacterContainer = IgeEntity.extend({
	classId: 'CharacterContainer',

	init: function () {
		var self = this;
		IgeEntity.prototype.init.call(this);

		self.size3d(20, 20, 40);

//		self.character = new Character()
//			.id(this.id() + '_character')
//			.setType(5)
//			.drawBounds(false)
//			.drawBoundsData(false)
//			.originTo(0.5, 0.6, 0.5)
//			.mount(this);
	},
// 
	walkTo: function (x, y) {
		var self = this,
			distX = x - this.translate().x(),
			distY = y - this.translate().y(),
			distance = Math.distance(
				this.translate().x(),
				this.translate().y(),
				x,
				y
			),
			speed = 9999999,
			time = (distance / speed),
			direction = '';

		// Set the animation based on direction - these are modified
		// for isometric views
		
        if (distY < 0) {
			direction += 'N';
		}
		if (distY > 0) {
			direction += 'S';
		}
		if (distX > 0) {
			direction += 'E';
		}
		if (distX < 0) {
			direction += 'W';
		}

//		switch (direction) {
//			case 'N':
//				this.character.animation.select('walkRight');
//				break;
//
//			case 'S':
//				this.character.animation.select('walkLeft');
//				break;
//
//			case 'E':
//				this.character.animation.select('walkRight');
//				break;
//
//			case 'W':
//				this.character.animation.select('walkLeft');
//				break;
//
//			case 'SE':
//				this.character.animation.select('walkDown');
//				break;
//
//			case 'NW':
//				this.character.animation.select('walkUp');
//				break;
//
//			case 'NE':
//				this.character.animation.select('walkRight');
//				break;
//
//			case 'SW':
//				this.character.animation.select('walkLeft');
//				break;
//		}

		this._translate.tween()
			.stopAll()
			.properties({x: x, y: y})
			.duration(time)
			.start();

		return this;
	},
	changeCursor: function (x, y) {
		var self = this,
			distX = x - this.translate().x(),
			distY = y - this.translate().y(),
			distance = Math.distance(
				this.translate().x(),
				this.translate().y(),
				x,
				y
			),
			speed = 9999999,
			time = (distance / speed),
			direction = '';

        if (distY < 0) {
			direction += 'N';
		}
		if (distY > 0) {
			direction += 'S';
		}
		if (distX > 0) {
			direction += 'E';
		}
		if (distX < 0) {
			direction += 'W';
		}

		switch (direction) {
			case 'N':
                $('body').css('cursor', 'ne-resize');
				break;

			case 'S':
                $('body').css('cursor', 'sw-resize');
				break;

			case 'E':
                $('body').css('cursor', 'se-resize');
				break;

			case 'W':
                $('body').css('cursor', 'nw-resize');
				break;

			case 'SE':
                $('body').css('cursor', 's-resize');
				break;

			case 'NW':
                $('body').css('cursor', 'n-resize');
				break;

			case 'NE':
                $('body').css('cursor', 'e-resize');
				break;

			case 'SW':
                $('body').css('cursor', 'w-resize');
				break;
		}

		return this;
	},

	tick: function (ctx) {
		this.depth(this._translate.y);
		IgeEntity.prototype.tick.call(this, ctx);
	}
});

if (typeof(module) !== 'undefined' && typeof(module.exports) !== 'undefined') { module.exports = CharacterContainer; }