/**
 * Adds mouse control to the entity this component is added to.
 * @type {IgeClass}
 */
var PlayerComponent = IgeClass.extend({
    classId: 'PlayerComponent',
    componentId: 'player',
    init: function(entity, options) {
        var self = this;

        this._entity = entity;

        this._options = options;
    },
    _mouseUp: function(event, x, y, button) {

        var tilePoint = ige.$('tileMap').mouseTileWorldXY().to2d();
        var max_= Math.abs(tilePoint.x) +  Math.abs(tilePoint.y); 
        
        Debug.info('[PlayerComponent] Cordinates : [' +tilePoint.x+','+tilePoint.y+']');
        
        var width_ = $(window).width(); 
        
        var max_w = (3000 - width_) / 2 - 190;
        
        if (max_ <= max_w){
            this._entity.walkTo(
                    tilePoint.x,
                    tilePoint.y
                    );
        } else {
            Debug.info('[PlayerComponent] Can\'t move : [' +x+','+y+']');
        }
    },
});

if (typeof (module) !== 'undefined' && typeof (module.exports) !== 'undefined') {
    module.exports = PlayerComponent;
}