/**
 * Client, ładowanie obiektów.
 *
 * @package     sfJSPlugin
 * @subpackage  map

 * @version     0.1-DEV
 * @type {Class}
 */

var GameClient = IgeClass.extend({
    classId: 'GameClient',
    init: function() {
        this.setupIge();

        var self = this;
        this.obj = [];
        this.gameTexture = {};

        this.implements([
            Agency,
            Bank,
            Buildings,
            HotelCenter,
            HotelDowntown,
            HotelSuburbs,
            LaborOffice,
            TownHall,
            Boats,
            Cars,
            Overlays,
            Train,
            Trees,
            HavenScene,
            BackgroundScene,
            MainScene,
            ObjectScene,
            ObjectLayer,
            Helicopters,
            TileMap,
            Stadium
        ]);

        ige.on('texturesLoaded', function() {
            ige.createFrontBuffer(true);

            ige.start(function(success) {

                if (success) {
                    ige.viewportDepth(true);
                    self.setupScene(self);
                    self.setupEntities();
                    mainScene.scaleBy(-0.4, -0.4, 0);
                }
            });
        });

        this.loadTextures();
    },
    implements: function(vars) {

        for (var i = 0; i < vars.length; i++) {
            this.implement(vars[i]);
        }
    },
    setupIge: function() {
        ige.input.debug(false);
        ige.showStats(true);
        ige.globalSmoothing(true);
    },
    setupScene: function() {

        self.mainScene = new this.MainScene('mainScene');

        self.objectScene = new this.ObjectScene('objectScene')
                .mount(self.mainScene);

        self.backgroundScene = new this.BackgroundScene('backgroundScene')
                .mount(self.mainScene);

        self.objectLayer = new this.ObjectLayer(350, 350, 'objectLayer')
                .mount(self.mainScene);

        self.objectHaven = new this.HavenScene().mount(self.mainScene);

        self.vp1 = new IgeViewport()
                .id('vp1')
                .autoSize(true)
                .scene(self.mainScene)
                .drawMouse(false)
                .drawBounds(false)
                .drawBoundsData(false)
                .mount(ige);

        self.tileMap = new this.TileMap('tileMap')
                .mount(self.objectScene);

//    this.player = new CharacterContainer()
//            .id('player')
//            .depth(-1)
//            .addComponent(PlayerComponent)
//            .isometric(true)
//            .mount(self.tileMap);
//
//    this.player.isBehind(self.tileMap);
//
//    var width_ = $(window).width();
//    var x = ((4000 - width_ ) / 2) / 100;
//
//    if (GameData.location == 'przedmiescia') {
//      this.player.translateToTile(-Math.round(x) + 2, 0, 0);
//    }
//
//    if (GameData.location == 'srodmiescie') {
//      this.player.translateToTile(Math.round(x) - 2, 0, 0);
//    }
//
//    self.vp1.camera.trackTranslate(this.player, 5);
    },
    loadTextures: function() {

        if (GameData.location == 'centrum' || GameData.location == "brak-wybranej-lokalizacji") {
            this.gameTexture.hc = new Array();
            this.gameTexture.hc['base.se'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/bottom.png');
            this.gameTexture.hc['stacker.se'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/repeat.png');
            this.gameTexture.hc['head.se'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/top.png');
            this.gameTexture.hc['base.seh'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/hover_bottom.png');
            this.gameTexture.hc['stacker.seh'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/hover_repeat.png');
            this.gameTexture.hc['head.seh'] = new IgeTexture('/assets/textures/buildings/centrum/' + GameData.kwartal + '/hover_top.png');
        }

        if (GameData.location == 'przedmiescia') {
            this.gameTexture.hp = new Array();
            this.gameTexture.hp['base.se'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/bottom.png');
            this.gameTexture.hp['stacker.se'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/repeat.png');
            this.gameTexture.hp['head.se'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/top.png');
            this.gameTexture.hp['base.seh'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/hover_bottom.png');
            this.gameTexture.hp['stacker.seh'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/hover_repeat.png');
            this.gameTexture.hp['head.seh'] = new IgeTexture('/assets/textures/buildings/right/' + GameData.kwartal + '/hover_top.png');
        }

        if (GameData.location == 'srodmiescie') {
            this.gameTexture.hs = new Array();
            this.gameTexture.hs['base.se'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/bottom.png');
            this.gameTexture.hs['stacker.se'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/repeat.png');
            this.gameTexture.hs['head.se'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/top.png');
            this.gameTexture.hs['base.seh'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/hover_bottom.png');
            this.gameTexture.hs['stacker.seh'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/hover_repeat.png');
            this.gameTexture.hs['head.seh'] = new IgeTexture('/assets/textures/buildings/left/' + GameData.kwartal + '/hover_top.png');
        }

        this.gameTexture.crane = new Array();
        this.gameTexture.crane['se'] = new IgeTexture('/assets/textures/buildings/crane_se.png');
        this.gameTexture.crane['sw'] = new IgeTexture('/assets/textures/buildings/crane_sw.png');
        this.gameTexture.crane['ne'] = new IgeTexture('/assets/textures/buildings/crane_ne.png');
        this.gameTexture.crane['nw'] = new IgeTexture('/assets/textures/buildings/crane_nw.png');

        this.gameTexture.bg = new Array();
        this.gameTexture.bg['base'] = new IgeTexture('/images/mapa/bg/ziemia-' + GameData.kwartal + '.jpg');
        this.gameTexture.bg['buildings'] = new IgeTexture('/images/mapa/bg/budynki-' + GameData.kwartal + '.png');
        this.gameTexture.bg['threes'] = new IgeTexture('/images/mapa/bg/drzewa-' + GameData.kwartal + '.png');
        this.gameTexture.bg['haven'] = new IgeTexture('/assets/textures/environment/chmury.png');

        if (GameData.mapHd) {
            this.gameTexture.train = new IgeTexture('/assets/textures/environment/train.png');

            this.gameTexture.helicopter = new Array();
            this.gameTexture.helicopter['se'] = new IgeCellSheet('/assets/textures/environment/h1.png', 1, 3);
        }

        this.gameTexture.stadium = new Array();
        this.gameTexture.stadium['se'] = new IgeCellSheet('/assets/textures/environment/stadium.png', 1, 3);


        this.gameTexture.th = new Array();
        if (Building.getStatus('ratusz') == 2) {
            this.gameTexture.th['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/ratusz_inactive.png', 1, 1);
        } else {
            this.gameTexture.th['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/ratusz.png', 1, 1);
            this.gameTexture.th['hover'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/ratusz_hover.png', 1, 1);
        }

        this.gameTexture.b = new Array();
        if (Building.getStatus('bank') == 2) {
            this.gameTexture.b['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/bank_inactive.png', 1, 1);
        } else {
            this.gameTexture.b['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/bank.png', 1, 1);
            this.gameTexture.b['hover'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/bank_hover.png', 1, 1);
        }

        this.gameTexture.a = new Array();
        if (Building.getStatus('agencja') == 2) {
            this.gameTexture.a['base'] =
                    new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/agencja_inactive.png', 1, 1);
        } else {
            this.gameTexture.a['base'] =
                    new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/agencja.png', 1, 1);
            this.gameTexture.a['hover'] =
                    new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/agencja_hover.png', 1, 1);
        }

        this.gameTexture.lo = new Array();
        if (Building.getStatus('urzad_pracy') == 2) {
            this.gameTexture.lo['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/urzadpracy_inactive.png', 1, 1);
        } else {
            this.gameTexture.lo['base'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/urzadpracy.png', 1, 1);
            this.gameTexture.lo['hover'] = new IgeCellSheet('/images/mapa/' + GameData.kwartal + '/urzadpracy_hover.png', 1, 1);
        }

        this.gameTexture.budynki =
                new IgeCellSheet('/images/mapa/budynki_pociag_' + GameData.kwartal + '.png', 1, 1);

        this.gameTexture.nakladka = new IgeTexture('/images/mapa/' + GameData.kwartal + '/nakladka.png');

        if (GameData.mapHd) {
            // BOATS TEXTURES
            this.gameTexture.boat = new Array();
            this.gameTexture.boat[1] = new IgeTexture('/images/mapa/lodki/l_1_1.png');
            this.gameTexture.boat[2] = new IgeTexture('/images/mapa/lodki/l_1_2.png');
            this.gameTexture.boat[3] = new IgeTexture('/images/mapa/lodki/l_1_3.png');
            this.gameTexture.boat[4] = new IgeTexture('/images/mapa/lodki/l_1_4.png');

            this.gameTexture.boat[5] = new IgeTexture('/images/mapa/lodki/l_2_1.png');
            this.gameTexture.boat[6] = new IgeTexture('/images/mapa/lodki/l_2_2.png');
            this.gameTexture.boat[7] = new IgeTexture('/images/mapa/lodki/l_2_3.png');
            this.gameTexture.boat[8] = new IgeTexture('/images/mapa/lodki/l_2_4.png');

            // CARS TEXTURES 
            this.gameTexture.car = new Array();
            this.gameTexture.car[1] = new IgeCellSheet('/assets/textures/environment/samochod_1.png', 1, 2);
            this.gameTexture.car[2] = new IgeCellSheet('/assets/textures/environment/samochod_2.png', 1, 2);
            this.gameTexture.car[3] = new IgeCellSheet('/images/mapa/samochody/car_13.png', 1, 1);

            this.gameTexture.car[4] = new IgeCellSheet('/assets/textures/environment/samochod_2_2.png', 1, 1);
            this.gameTexture.car[5] = new IgeCellSheet('/assets/textures/environment/samochod_1_2.png', 1, 1);
            this.gameTexture.car[6] = new IgeCellSheet('/images/mapa/samochody/car_12.png', 1, 1);

            this.gameTexture.car[7] = new IgeTexture('/images/mapa/samochody/car_4.png');
            this.gameTexture.car[8] = new IgeTexture('/images/mapa/samochody/car_24.png');
            this.gameTexture.car[9] = new IgeTexture('/images/mapa/samochody/car_3.png');
            this.gameTexture.car[10] = new IgeTexture('/images/mapa/samochody/car_23.png');

            this.gameTexture.bus = new Array();
            this.gameTexture.bus[1] = new IgeCellSheet('/images/mapa/samochody/bus_3.png', 1, 1);
            this.gameTexture.bus[2] = new IgeCellSheet('/images/mapa/samochody/bus_2.png', 1, 1);
            this.gameTexture.bus[3] = new IgeTexture('/images/mapa/samochody/bus_4.png');
            this.gameTexture.bus[4] = new IgeTexture('/images/mapa/samochody/bus_1.png');

            this.gameTexture.truck = new Array();
            this.gameTexture.truck[1] = new IgeTexture('/images/mapa/samochody/truck_2.png');
            this.gameTexture.truck[2] = new IgeTexture('/images/mapa/samochody/truck_4.png');
        }

        ige.on([
            [this.gameTexture.bg.base, 'loaded'],
            [this.gameTexture.bg.buildings, 'loaded'],
            [this.gameTexture.bg.threes, 'loaded'],
            [this.gameTexture.bg.haven, 'loaded'],
        ], function() {
            Debug.info('[MAPA] Załadowano tło mapy');
        });

    },
    setupEntities: function() {
        this.obj['overlay'] = new this.Overlay(self.tileMap, -4.71, 5.101);

        this.obj['bg'] = new Array();
        this.obj['bg']['trees'] = new this.BackgroundTrees(self.tileMap, -0.3, -0.1);
        this.obj['bg']['buildings'] = new this.BackgroundBuildings(self.tileMap, -0.3, -0.2);

        if (GameData.mapHd) {
            this.obj['train'] = new this.Train(self.tileMap, 0, 5.1).depth(-1);
        }

        this.obj['stadium'] = new this.Stadium(self.tileMap, 9, 14.1, 'se');
        this.obj['stadium'].depth(-1);


        if (GameData.location == 'srodmiescie') {
            this.obj['hotel'] = new this.HotelDowntown(self.tileMap, 12.9, 0.2);

            if (GameData.mapHd) {
                this.obj['helicopter'] = new this.Helicopter(self.tileMap, 2.8, 1.7, 'se');
                this.obj['helicopter'].animate(1, 1);
            }
        }

        if (GameData.location == 'centrum' || GameData.location == "brak-wybranej-lokalizacji") {
            if (GameData.mapHd) {
                this.obj['helicopter'] = new this.Helicopter(self.tileMap, 2.3, 0.7, 'se');
            }

            this.obj['hotel'] = new this.HotelCenter(self.tileMap, 0.25, -1.5);
if (typeof this.obj.helicopter != 'undefined') {
            this.obj.helicopter.hide();
            }
        }

        if (GameData.location == 'przedmiescia') {
            if (GameData.mapHd) {
                this.obj['helicopter'] = new this.Helicopter(self.tileMap, 2.8, 1.7, 'se');
                this.obj['helicopter'].animate(1, 1);
            }

            this.obj['hotel'] = new this.HotelSuburbs(self.tileMap, 0.25, -1.5);
            this.obj['hotel'].translateTo(-1325, -45, 5);
        }


        this.obj['buildings'] = new this.Buildings(self.tileMap, -4, 6);

        this.obj['town_hall'] = new this.TownHall(self.tileMap, 0.9, 4.3);
        this.obj['bank'] = new this.Bank(self.tileMap, -4.9, 2.2);
        this.obj['agency'] = new this.Agency(self.tileMap, 8.2, 3);
        this.obj['labor_office'] = new this.LaborOffice(self.tileMap, 6.7, -1.35);

        if (GameData.mapHd) {
            this.obj['boat'] = new Array();
            this.obj['boat']['1'] = new this.Boat(self.tileMap, 8.5, -1.2, 2).animate(1, 1);
            this.obj['boat']['1'] = new this.Boat(self.tileMap, 8.9, -1.6, 5);
            this.obj['boat']['1'] = new this.Boat(self.tileMap, 8.5, -2.1, 7).animate(1, 1.1);


            this.obj['boat']['2'] = new this.Boat(self.tileMap, 4.5, -13.2, 2).animate(2, 1);
            this.obj['boat']['3'] = new this.Boat(self.tileMap, 3.5, -13.2, 3).animate(3, 1);
            this.obj['boat']['4'] = new this.Boat(self.tileMap, 1.5, -13.2, 2).animate(4, 1);

            this.obj['boat']['2'] = new this.Boat(self.tileMap, 3.5, -13.2, 5).animate(2, 1.5);
            this.obj['boat']['3'] = new this.Boat(self.tileMap, 2.9, -13.2, 6).animate(3, 1.4);
            this.obj['boat']['4'] = new this.Boat(self.tileMap, 2.5, -13.2, 7).animate(4, 1.3);

            this.obj['car'] = new Array();
            // # SMOCHODY W CENTRUM
            this.obj['car']['1'] = new this.Car(self.tileMap, -0.1, -8, 1).animate(2, 1);
            this.obj['car']['2'] = new this.Car(self.tileMap, -0.1, -8, 3).animate(3, 1);

            // # SAMOCHÓD - lewy górny 
            this.obj['car']['3'] = new this.Car(self.tileMap, -12.1, -6.8, 4).animate(4, 1);
            // # SAMOCHÓD - pod hotelem, klient :D
            this.obj['car']['4'] = new this.Car(self.tileMap, -2, 0.2, 4).animate(5, 1);
            // ## SAM -- 
            this.obj['car']['5'] = new this.Car(self.tileMap, -3, -2.45, 5).animate(6, 1);
            this.obj['car']['6'] = new this.Car(self.tileMap, -4.5, -2.5, 6).animate(7, 1);
            this.obj['car']['7'] = new this.Car(self.tileMap, -4.8, -2.6, 7).animate(8, 1);
            // # SAMOCHÓD - pod bankiem, klient :D
            this.obj['car']['8'] = new this.Car(self.tileMap, -7.7, 3.3, 8).animate(9, 1);
            // # AUTOSTRADA W PRAWO // 
            this.obj['car']['9'] = new this.Car(self.tileMap, -7.3, 14.6, 9).animate(10, 1);
            this.obj['car']['10'] = new this.Car(self.tileMap, -7.3, 14.6, 10).animate(11, 1);
            this.obj['car']['11'] = new this.Car(self.tileMap, -7.3, 14.6, 11).animate(12, 1);
            this.obj['car']['12'] = new this.Car(self.tileMap, -7.3, 14.6, 12).animate(13, 1);
            this.obj['car']['13'] = new this.Car(self.tileMap, -7.3, 14.6, 9).animate(14, 1);
            // # AUTOSTRADA W LEWO 
            this.obj['car']['14'] = new this.Car(self.tileMap, -7.9, 14.6, 13).animate(15, 1);
            this.obj['car']['15'] = new this.Car(self.tileMap, -7.9, 14.6, 14).animate(16, 1);
            this.obj['car']['16'] = new this.Car(self.tileMap, -7.9, 14.6, 15).animate(17, 1);
            this.obj['car']['17'] = new this.Car(self.tileMap, -7.9, 14.6, 16).animate(18, 1);
            this.obj['car']['18'] = new this.Car(self.tileMap, -7.9, 14.6, 13).animate(19, 1);
            // # U DOŁU 
            this.obj['car']['19'] = new this.Car(self.tileMap, -12, 9, 5).animate(20, 1);
            this.obj['car']['20'] = new this.Car(self.tileMap, -8, 14.2, 5).animate(21, 1);
            this.obj['car']['21'] = new this.Car(self.tileMap, -7, 14.2, 6).animate(22, 1);
            this.obj['car']['22'] = new this.Car(self.tileMap, -7, 14, 7).animate(23, 1);
        }
    }
});
if (typeof (module) !== 'undefined' && typeof (module.exports) !== 'undefined') {
    module.exports = GameClient;
}
