/**
 * Klasa zawierająca metody do zarządzania Menu.
 *
 * @package     sfJSPlugin
 * @subpackage  menu/menu

 * @version     0.1-DEV
 * @type {Class}
 */
var Menu = new Class({
    initialize: function() {
  }
});

var modalRequest = new Request({
  evalScripts: true,
  method: 'get',
  onRequest: function() {
    AjaxLoader.loadBeforeAjax();
  },
  onSuccess: function(responseText) {
    $('#modalContainer').html(responseText);
    AjaxLoader.loadAfterAjax();
  },
  onFailure: function() {
    $('.modal-spinner').hide();
    $('.global-spinner').hide();
    $('.modal-backdrop').remove();
    NoticeCenter.ajaxError(); 
  }
});

//Debug.object(modalRequest);

Menu.extend({
  /**
   * Pobiera dane i wyświetla je w popupie.
   *
   * @param name
   */
  getModal: function(name, params) {
    modalRequest.options.url = Routing.generate(name, params);
    modalRequest.options.name = name;

    Debug.info("[Menu] Trasa : " + modalRequest.options.url); 

    if (modalRequest.isRunning())
    {
      Debug.info("[Menu] Request already running");
    }
    else {
      RequestHistory.addRequest(jQuery.extend({}, modalRequest)); 
      modalRequest.send();

      Debug.info("[Menu] Request started");
    }
  }, 
  getBuildingModal: function(name) {
    
    Building.getBuilding(name);
    
  }
});