var AdviserObject = {};

var Adviser = new Class({
  id: false,
  options : {
    closeBtn: false,     nextBtn: true,
    thxBtn: true,
    prevBtn: true,   }, 
  opts: {},
  initialize: function(text, opts) {
    this.id = 'ADVISER_'+MD5(Math.random(1, 356789078907807).toString());
    this.opts = opts;
    // $('.adviser-backdrop').click(function(){
    //     alert('clicked');
    // });
    
    this.clearChanges(); 
    
    if (isset(this.opts.eval))
        eval(this.opts.eval);
    
    if (isset(this.opts.nextBtn) && this.opts.nextBtn && this.options.nextBtn) {
      var nextBtn = '<span class="btn fr mt10" onclick="' + this.opts.nextBtn + '">Dalej</span>';
    } else {
      var nextBtn = "";
    }

    if (isset(this.opts.thxBtn) && this.opts.thxBtn && this.options.thxBtn) {
      var thxBtn = '<span class="btn fr mt10" onclick="$(\'#' + this.id + '\').remove();">' + this.opts.thxBtn + '</span>';
    } else {
      var thxBtn = "";
    }
    
    if (isset(this.opts.prevBtn) && this.opts.prevBtn && this.options.prevBtn) {
      var prevBtn = '<span class="btn fr mt10" onclick="' + this.opts.prevBtn + '">Wstecz</span>';
    } else {
      var prevBtn = "";
    }
    
    if (isset(this.opts.closeBtn) && this.opts.closeBtn && this.options.closeBtn) {
      var closeBtn = '<span class="btn fr mt10" onclick="' + this.opts.closeBtn + '">Zamknij</span>';
    } else {
      var closeBtn = "";
    }

    var text = '<span class="text">' + text + nextBtn + thxBtn + prevBtn + closeBtn + '</span>';
    var close = '<span class="close" onclick="$(\'#' + this.id + '\').remove();" ></span>';

    if (isset(this.opts.img)) {
      if (isset(opts.img_bg) && opts.img_bg){
        var img = '<img class="img_bg" src="' + this.opts.img + '"/>';
      } else {
        var img = '<img src="' + this.opts.img + '"/>';
      }
    } else {
      var img = "";
    }

    if (isset(opts.width)) {
      var width = opts.width;
      var margin = 100 - width;
    } else {
      var width = 20;
      var margin = 80;
    }

    if (isset(opts.position)) {

      if (opts.position == 'left') {
        var pos1 = 'right';
        var pos2 = 'left';
      }
      else if (opts.position == 'right') {
        var pos1 = 'left';
        var pos2 = 'right';
      } else {
        Debug.error("[Adviser] Nie obsługiwana pozycja");
      }
    } else {
      var pos1 = 'left';
      var pos2 = 'right';
    }
    
    if (! isset(opts.style)) {
      opts.style = 'style1';
    }

    var _body = '<div style="width:' + width + '%; ' + pos1 + ':' + margin + '%;'  + pos2 + ': 0;" id="'
            + this.id
            + '" class="modal-backdrop adviser-backdrop fade in '+opts.position+' '+opts.style+'">'
            + img
            + unescape(text)
            + close
            + '</div>'; 
            
    $('body').append(_body);
    Debug.info("[Adviser] Otwarto : " + this.id);
    
    return true;
  },
  destroy: function() {
    Debug.info("[Adviser] Zamknięto : " + this.id);
    $("#" + this.id).remove();
    $('.modal-backdrop.fade.in').remove();
    
    this.clearChanges(); 
  },
  hide: function() {
    $("#" + this.id).hide('slow');
    $('.modal-backdrop.fade.in').remove();
    
    this.clearChanges(); 
  },
  clearChanges: function(){
    $('html body table.left').css({'z-index' : '4510'});

    $('#Raports .box').removeClass('hover'); 
    $('#Messages .box').removeClass('hover'); 
    $('#Decisions .box').removeClass('hover'); 
    $('#Buildings .building').removeClass('hover');
    $('.game-status').removeClass('hover');
      
  }, 
  show: function() {
    $("#" + this.id).show('slow');
  },
}).extend({
  set: function(text, opts) {
    if (isset(opts)) {

      if (is_object(opts))
        var opts = opts;
      else 
        var opts = JSON.parse(unescape(opts));
    } else {
        var opts = {};
    }

    if (AppConfig.adviser) {
      if (isset(text) || isset(opts.img)) {
        try {
          Debug.info("[Adviser] Otwieram okno doradzcy");
          if (isset(AdviserObject.destroy)) {
            AdviserObject.destroy();
          }

          AdviserObject = {};
          AdviserObject = new Adviser(text, opts);
        } catch(e){
          Debug.error('[Adviser] ' + e);
        }
      } else {
        Debug.warning("[Adviser] Brak danych nie otwieram okna doradzcy")
      }
    }
  },
});

Adviser.Queue = new Class({
  Implements: [Options, Events],
  options: {
    iterator: 0,
    data: {},
  },
  name: null,
  initialize: function(name, options) {

    if (options) {
      this.options.data = options.data;
      delete options.data;
    }

    Debug.info("[Adviser.Queue] Zainicjalizowano kolejkę doradcy");
    this.name = name;
    window[name] = this;

    this.start();
  },
  isLast: function() {
    if (Object.keys(this.options.data).length === (this.options.iterator + 1)) {
      return true;
    } else {
      return false;
    }
  },
  start: function() {
    this.options.data[this.options.iterator].nextBtn = this.name + '.next();';
    Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);

    this.options.iterator++;
  },
  next: function() {

    if (this.isLast()) {
      Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);
    } else {
      this.options.data[this.options.iterator].nextBtn = this.name + '.next();';
      Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);
    }

    this.options.iterator++;
  },
  prev: function() {
    this.options.iterator--;

    if (this.isFirst() && this.isLast()) {
      Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);
    } else if(this.isLast()) {
      this.options.data[this.options.iterator].prevBtn = this.name + '.prev();';
      Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);
    } else {
      this.options.data[this.options.iterator].nextBtn = this.name + '.next();';
      this.options.data[this.options.iterator].prevBtn = this.name + '.prev();';
      Adviser.set(__(this.options.data[this.options.iterator].name), this.options.data[this.options.iterator]);      
    }
  },
}).extend({
  Queue0: {
    0: {name: 'ekran_glowny_status_bar'
        , position: 'right'
        , eval: "\
            $('.game-status').addClass('hover'); \n\
            "
        , width: 100
        , img_bg: true},
    1: {name: 'ekran_glowny_hotel'
        , position: 'right'
        , eval: "\n\
            $('.game-status').removeClass('hover'); \n\
            $('#Buildings .building.hotel').addClass('hover'); \n\
            $('html body table.left').css({'z-index' : '5555'}); \n\
            "
        , width: 100
        , img_bg: true},
    2: {name: 'ekran_glowny_bank'
        , position: 'right'
        , eval: "\n\
            $('#Buildings .building').removeClass('hover'); \n\
            $('#Buildings .building.bank').addClass('hover'); \n\
            $('html body table.left').css({'z-index' : '5555'}); \n\
            "
        , width: 100
        , img_bg: true},
    3: {name: 'ekran_glowny_ratusz'
        , position: 'right'
        , eval: "\
            $('#Buildings .building').removeClass('hover'); \n\
            $('#Buildings .building.ratusz').addClass('hover'); \n\
            $('html body table.left').css({'z-index' : '5555'}); \n\
            "
        , width: 100
        , img_bg: true},
    
    4: {name: 'ekran_glowny_agencja', position: 'right'        
            , eval: "\
            $('#Buildings .building').removeClass('hover'); \n\
            $('#Buildings .building.agencja').addClass('hover'); \n\
            $('html body table.left').css({'z-index' : '5555'}); \n\
            "
          , width: 100},
      
    5: {name: 'ekran_glowny_urzad', position: 'right'
            , eval: "\
            $('#Buildings .building').removeClass('hover'); \n\
            $('#Buildings .building.urzad_pracy').addClass('hover'); \n\
            $('html body table.left').css({'z-index' : '5555'}); \n\
            "
          , width: 100},
      
    6: {name: 'ekran_glowny_wiadomosci'
            , position: 'left'
            , eval: "\
            $('html body table.left').css({'z-index' : '4510'}); \n\
            $('#Buildings .building').removeClass('hover'); \n\
            $('#Messages .box').addClass('hover');  \n\
            "
        , width: 100},
    
    7: {name: 'ekran_glowny_log'
        , position: 'left'
        , eval: "\
            $('#Messages .box').removeClass('hover');  \n\
            $('#Decisions .box').addClass('hover');  \n\
            "
        , width: 100},
    8: {name: 'ekran_glowny_raporty'
        , position: 'left'
        , eval: "\
            $('#Decisions .box').removeClass('hover');  \n\
            $('#Raports .box').addClass('hover');  \n\
            "
        , width: 100},
    
    9: {name: 'ekran_glowny_koniec'
        , position: 'right'
        , eval: "\
            $('#Raports .box').removeClass('hover');  \n\
            $('#Buildings .building').removeClass('hover'); \n\
            "        
        , width: 100
        , thxBtn : 'Dzięki'},
  },
})
