/**
 * Klasa zawierająca metody do zarządzania Wiadomości
 *
 * @package     sfJSPlugin
 * @subpackage  app/other

 * @version     0.1-DEV
 * @type {Class}
 */

var messageRequest = new Request.JSON({
  method: 'get',
  onRequest: function() {
    // Duży obrazek ładujemy wcześniej
    new Image().src = "/images/Glos-pekunii.png";
    AjaxLoader.loadBeforeAjax();
  },
  onSuccess: function(responseJSON, responseText) {

    Object.each(responseJSON.Components, function(value, key) {
      JsRequest.parseComponent(key, value);
    });

    if (isset(responseJSON.HTML)) {
      $('#modalContainer').html(responseJSON.HTML.value);
      
      // Duży obrazek tła, ładujemy tło później texty w środku >> 
//      $(".popup-all > div").hide(); 
//      $(".popup-all").on('load', function(){ 
//        $(this).addClass('Loades'); 
//        Debug.info("[messageRequest] Obrazki załadowane !");  
//        $(".popup-all > div").show(); 
//      });
//      
//      $(".popup-all > div").show(); 
    }

    AjaxLoader.loadAfterAjax();
  },
  onFailure: function() {
    $('html').unspin();
    NoticeCenter.ajaxError(); 
  }
});

var Message = new Class({
  /**
   * inicjalizacja zmiennej
   */
  menu: null,
  /**
   * inicjalizacja zmiennej
   */
  menuElement: null,
  /**
   * Ilośc nowych wiadomości.
   */
  count: "#M_MessageCount",
  /**
   * Inicjalizacja obiektu.
   */
  initialize: function() {
    this.menu = $('#Messages');
    this.menuElement = $('#Messages > li > a');
  },
  /**
   * Dodaje Listener na Menu, oraz akcje która ma się wykonać po kliknięciu w daną pozycję.
   *
   * @param element
   * @param container
   */
  addListener: function(element, container) {

    
  },
}).implement({
}).extend({
  getMessageModal: function(element) {
    AjaxLoader.loadBeforeAjax();
    var messageId = element.get('id');

    messageRequest.options.url = Routing.generate('message_show', {
      id: messageId
    });

    if (messageRequest.isRunning())
    {
      Debug.info("[Message] Request already running");
    }
    else {
      messageRequest.send();
      RequestHistory.addRequest(jQuery.extend({}, messageRequest));
      Debug.info("[Message] Request started");
    }

  },
  getMessageListModal: function(filter) {
    messageRequest.options.url = Routing.generate('message_list', {filter: filter});

    if (messageRequest.isRunning())
    {
      Debug.info("[Message] Request already running");
    } else {
      messageRequest.send();
      RequestHistory.addRequest(jQuery.extend({}, messageRequest));
      Debug.info("[Message] Request started");
    }

  },
  setMessageCount: function(value) {
    $('#M_MessageCount').html(unescape(value));
  },
  getUnreadMessageModal: function(that) {
    Message.getMessageModal(that);
  },
  setHtml: function(html) {

    $('#Messages').html(unescape(html));
  },
});

var messages = new Message();