/**
 * Klasa zawierająca metody do zarządzania Kwadracików.
 *
 * @package     sfJSPlugin
 * @subpackage  menu/menu

 * @version     0.1-DEV
 * @type {Class}
 */
var Square = new Class({
    initialize: function() {
  }
});

var squareRequest = new Request.JSON({
  evalScripts: true,
  method: 'get',
  onRequest: function() {
    AjaxLoader.loadBeforeAjax();
  },
  onSuccess: function(responseJSON, responseText) {
    Object.each(responseJSON.Components, function(value, key) {
      JsRequest.parseComponent(key, value);
    });

    if (isset(responseJSON.HTML)) {
      $('#modalContainer').html(responseJSON.HTML.value);
    }
    
    AjaxLoader.loadAfterAjax();
  },
  
  onFailure: function(){
    $('html').unspin();
    NoticeCenter.ajaxError(); 
  }
});

//Debug.object(modalRequest);

Square.extend({
  /**
   * Pobiera dane i wyświetla je w popupie.
   *
   * @param name
   */
  getModal: function(params) {
    squareRequest.options.url = Routing.generate('panelGry_gameController', params);
    squareRequest.options.name = name;

    Debug.info("[Square] Trasa : " + squareRequest.options.url);

    if (squareRequest.isRunning() || i18nRequest.isRunning())
    {
      Debug.info("[Square] Request already running");
    }
    else {
      squareRequest.send();
      RequestHistory.addRequest(jQuery.extend({}, squareRequest));

      Debug.info("[Square] Request started");
    }
  },
});