/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */


var Validator = new Class({}).extend({
    onChange: function(id, json) {

        $("#" + id).parent().parent().parent().parent().find(".spin").first().spin("tiny");
        $("#" + id).parent().parent().parent().parent().removeClass("error");
        $("#" + id).parent().parent().parent().parent().find(".errors").remove();

        $.each($(".errors"), function() {
            if ($(this).next().attr("id") == id) {
                $(this).remove();
            }
        });

        $.getJSON(Routing.generate("ajaxFormValidator_validateJSON"), json, function(data) {

            if (!data.isValid) {
                var mes = "";
                for (i = 0; i < data.messages.length; i++) {
                    mes += "<span class=\'w100 fl\'> <i class=\'icon-error fl\'></i> " + data.messages[i] + "</span>";
                }

                $('[error="' + id + '"]').remove();
                $("#" + id).parent().parent().before("<div class=\"errors \" error=\"" + id + "\">" + mes + "</div>");
                $("#" + id).parent().parent().parent().parent().addClass("error");
            } else {
                // AW: Strasznie na chama, zmienone pod widget wyboru
                var tempDOM = $("#" + id).parent().parent().parent().parent().find(".fieldInfo")
                if (tempDOM.length == 0) {
                    $("#" + id).parent().parent().parent().parent().parent().find(".fieldInfo").html(data.info);
                } else {
                    tempDOM.html(data.info);
                }
                AjaxLoader.sumFormCosts();

                if (isset(AbsurdityDecisions) && !is_null(data.absurdity)) {
                    AbsurdityDecisions.push(data.absurdity);
                }
            }

            if (isset(data.adviser)){
                // alert(data.adviser); 
                // alert('adviser');

                if (isset(data.adviser[1])){
                    Adviser.set(data.adviser[0], data.adviser[1]);
                } else {
                    Adviser.set(data.adviser[0]);
                }
            }

            $("#" + id).parent().parent().parent().parent().find(".spin").first().unspin();
        });
    },
    onChangeSave: function(id, json) {

        $("#" + id).parent().parent().parent().spin("tiny");
        $("#" + id).parent().parent().parent().removeClass("error");

        $('[error="' + id + '"]').remove();
        $("#" + id).attr('value', json.value);

        $.getJSON(Routing.generate("panelGry_saveDecision"), json, function(data) {

            if (!data.isValid) {
                // Błędy formularza
                var mes = "";

                for (i = 0; i < data.messages.length; i++) {
                    mes += "<span class=\'w100 fl\'> <i class=\'icon-error fl\'></i> " + data.messages[i] + "</span>";
                }

                $('[error="' + id + '"]').remove();
                $("#" + id).parent().parent().parent().parent().after("<div class=\"errors \" error=\"" + id + "\">" + mes + "</div>");

                $("#" + id).parent().parent().parent().addClass("error");
            } else {
                // Formularz poprawny. 
                var Options = jQuery.parseJSON(json.options);

                var ValidateFunction = Options.fieldName.camelize();

                Debug.info("[Validator] Próba uruchomienia funkcji Validators." + ValidateFunction + "();");

                if (typeof window.Validators[ValidateFunction] == 'function')
                {
                    window.Validators[ValidateFunction](json.value);
                    Debug.info("[Validator] Funkcja Validators." + ValidateFunction + "(" + json.value + "); znaleziona, i uruchomiona");
                } else {
                    Debug.warning("[Validator] Nie ma takiej funkcji : Validators." + ValidateFunction + "(" + json.value + ")");
                }

                Validators.setKosztPracownicy(escape(data.kosztObslugiStale), escape(data.kosztObslugiZlecenie), escape(data.kosztAdministracjiStale), escape(data.kosztAdministracjiZlecenie));
            }

            $("#" + id).parent().parent().parent().unspin();
        });
    },
    saveDecision: function(id, json) {
        Debug.info("[Validator] Zapis decyzji");

        $("#" + id).parent().parent().parent().spin("tiny");
        $("#" + id).parent().parent().parent().removeClass("error");

        $('[error="' + id + '"]').remove();
        $("#" + id).attr('value', json.value);

        $.getJSON(Routing.generate("panelGry_saveDecision"), json, function(data) {
            Form.hideNotice();

            if (!data.isValid) {
                Form.setError(__("Wystąpiły błędy, decyzja nie została zapisana"));

                var mes = "";
                for (i = 0; i < data.messages.length; i++) {
                    mes += "<span class=\'w100 fl\'> <i class=\'icon-error fl\'></i> " + data.messages[i] + "</span>";
                }

                $("#" + id).parent().parent().before("<div class=\"errors \" error=\"" + id + "\">" + mes + "</div>");
                $("#" + id).parent().parent().parent().addClass("error");


            } else {
                Form.setInfo(__("Decyzja została zapisana."));

                // Formularz poprawny. 
                var Options = jQuery.parseJSON(json.options);

                var ValidateFunction = Options.fieldName.camelize();

                GameStatus.setHtml(data.status);

                if (id !== 'decision_form_kredyt_inwestycyjny_kwota') {
                  $("#" + id).val(0);
                  $("#" + id).change();
                }

                Debug.info("[Validator] Próba uruchomienia funkcji Validators." + ValidateFunction + "();");

                if (typeof window.Validators[ValidateFunction] == 'function')
                {
                    window.Validators[ValidateFunction](json.value, data);
                    Debug.info("[Validator] Funkcja Validators." + ValidateFunction + "(" + json.value + ',' + data + "); znaleziona, i uruchomiona");
                } else {
                    Debug.warning("[Validator] Nie ma takiej funkcji : Validators." + ValidateFunction + "(" + json.value + ',' + data + ")");
                }
            }

            $("#" + id).parent().parent().parent().unspin();
            Helper.updateScroll();
        });
    },
});


/**
 * Klasa z metodami uruchamianymi po walidacji i zapisie w GC // 
 * 
 * #pracownicy_obslugi_stale. 
 * 
 * @type Class
 */
var Validators = new Class({
}).extend({
    setKosztPracownicy: function(obslugiStale, obslugiZlecenie, administracjiStale, administracjiZlecenie) {
      $('#koszt_obslugi_stale').html(unescape(obslugiStale));
      $('#koszt_obslugi_zlecenie').html(unescape(obslugiZlecenie));
      
      $('#koszt_administracji_stale').html(unescape(administracjiStale));
      $('#koszt_administracji_zlecenie').html(unescape(administracjiZlecenie));

      Debug.info("[Validators] Ustawiono koszty: Administracji | Obsługi");
    },
    PracownicyObslugiLiczba: function(ilosc) {

        var NaZlecenie = $('#decision_form_pracownicy_obslugi_zlecenie').attr('value');

        $('#decision_form_pracownicy_obslugi_zlecenie').change();
    },
    PracownicyObslugiZlecenie: function(NaZlecenie) {
        Config.debug = false;

        Debug.info("[Validators] NA_STAŁE (1): " + $('#decision_form_pracownicy_obslugi_liczba').attr('value'));
        Debug.info("[Validators] NA_ZLECENIE : " + NaZlecenie);

        var NaStale = $('#decision_form_pracownicy_obslugi_liczba').attr('value') - NaZlecenie;
        Debug.info("[Validators] NA_STAŁE (2): " + NaStale);

        $('#pracownicy_obslugi_stale').attr('value', NaStale);
        Config.debug = true;
    },
    PracownicyAdministracjiLiczba: function(ilosc) {
        var NaZlecenie = $('#decision_form_pracownicy_administracji_zlecenie').attr('value');

        $('#decision_form_pracownicy_administracji_zlecenie').change();
    },
    PracownicyAdministracjiZlecenie: function(NaZlecenie) {
        Config.debug = false;

        Debug.info("[Validators] NA_STAŁE (1): " + $('#decision_form_pracownicy_administracji_liczba').attr('value'));
        Debug.info("[Validators] NA_ZLECENIE : " + NaZlecenie);

        var NaStale = $('#decision_form_pracownicy_administracji_liczba').attr('value') - NaZlecenie;
        Debug.info("[Validators] NA_STAŁE (2): " + NaStale);

        $('#pracownicy_administracji_stale').attr('value', NaStale);
        Config.debug = true;
    },
    KredytObrotowySplata: function(value, data) {
        Debug.object(data);

        var kwota = data.kredytObrotowy;

        $('#decision_form_kredyt_obrotowy_splata').val(0);
        $('#decision_form_kredyt_obrotowy_kwota').val(kwota);
        $('#decision_form_kredyt_obrotowy_kwota').change();

    },
    KredytObrotowyKwota: function(value, data) {

        Debug.object(data);
    },
    LokataSplata: function(value, data) {
        
        $('#decision_form_lokata_kwota').change();
    }
});