/**
 * Raporty.
 *
 * @package     sfJSPlugin
 * @subpackage  raports

 * @version     0.1-DEV
 * @type {Class}
 */

function showTooltip(x, y, contents, z) {
    $('<div id="flot-tooltip">' + contents + '</div>').css({
        position: 'absolute',
        display: 'none',
        top: y - 30,
        left: x - 110,
        'font-weight': 'bold',
        border: '1px solid rgb(255, 221, 221)',
        'border-radius': '6px',
        padding: '2px',
        'background-color': z,
        opacity: '0.7'
    }).appendTo("body").show();
}

var raportRequest = new Request({
    method: 'get',
    evalScripts: true,
    onRequest: function() {
        AjaxLoader.loadBeforeAjax();
    },
    onSuccess: function(responseText) {
        $('#modalContainer').html(responseText);
        AjaxLoader.loadAfterAjax();
    },
    onFailure: function() {
        $('html').unspin();
        NoticeCenter.ajaxError();
    }
});

var Raport = new Class({
    /**
     * inicjalizacja zmiennej
     */
    menu: null,
    /**
     * inicjalizacja zmiennej
     */
    menuElement: null,
    /**
     * Ilośc nowych wiadomości.
     */
    count: "#M_RaportCount",
    /**
     * Inicjalizacja obiektu.
     */
    initialize: function() {
        this.menu = $('#Raports');
        this.menuElement = $('#Raports > li > a');
    },
    /**
     * Dodaje Listener na Menu, oraz akcje która ma się wykonać po kliknięciu w daną pozycję.
     *
     * @param element
     * @param container
     */
    addListener: function(element, container) {
            },
    getRaportOperacyjnyModal: function(element) {

        AjaxLoader.loadBeforeAjax();
        raportRequest.options.url = Routing.generate('raport_operacyjny_show');
        if (raportRequest.isRunning())
        {
            Debug.info("[Raport] Request already running");
        }
        else {
            raportRequest.send();
            RequestHistory.addRequest(jQuery.extend({}, raportRequest));
            Debug.info("[Raport] Request started");
        }
    },
    getRaportFinansowyModal: function(element) {
        AjaxLoader.loadBeforeAjax();
        raportRequest.options.url = Routing.generate('raport_finansowy_show');
        if (raportRequest.isRunning())
        {
            Debug.info("[Raport] Request already running");
        }
        else {
            raportRequest.send();
            RequestHistory.addRequest(jQuery.extend({}, raportRequest));
            Debug.info("[Raport] Request started");
        }
    },
    getRaportKpirModal: function(element) {
        AjaxLoader.loadBeforeAjax();
        raportRequest.options.url = Routing.generate('raport_kpir_show');
        if (raportRequest.isRunning())
        {
            Debug.info("[Raport] Request already running");
        }
        else {
            raportRequest.send();
            RequestHistory.addRequest(jQuery.extend({}, raportRequest));
            Debug.info("[Raport] Request started");
        }

    },
    getRaportRankingModal: function(element) {
        AjaxLoader.loadBeforeAjax();
        raportRequest.options.url = Routing.generate('raport_ranking_show');
        if (raportRequest.isRunning())
        {
            Debug.info("[Raport] Request already running");
        }
        else {
            raportRequest.send();
            RequestHistory.addRequest(jQuery.extend({}, raportRequest));
            Debug.info("[Raport] Request started");
        }
    }

}).implement({
    setRaportCount: function(value) {

        $(this.count).html(value);
    }
}).extend({
    setHtml: function(html) {

        $('#Raports').html(unescape(html));
    },
    toggleSection: function(record, level, that) {

        if (level == 1) {
            $('[level="2"]').css({'display': 'none'});
            $('[level="3"]').css({'display': 'none'});

            Object.each($('[level="2"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });

            Object.each($('[level="1"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });

            Object.each($('[level="3"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });
        }

        if (level == 2) {
            $('[level="3"]').css({'display': 'none'});

            Object.each($('[level="2"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });

            Object.each($('[level="3"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });
        }

        if (level == 3) {
            RequestHistory.addRequest(jQuery.extend({}, raportRequest));
            Object.each($('[level="3"]').find('i'), function(value, key) {

                if ($(value).is('.icon-minus')) {
                    $(value).removeClass('icon-minus').addClass('icon-plus');
                }
            });
        }

        var _i = that.find('i').first();

        if (_i.is('.icon-plus')) {
            _i.removeClass('icon-plus').addClass('icon-minus');
        } else {
            _i.removeClass('icon-minus').addClass('icon-plus');
        }

        $('[chart]').hide();
        $('.icon-eye-close').removeClass('icon-eye-close').addClass('icon-eye-open');

        $('[record="' + record + '"]').toggle('slow');
        Helper.updateScroll();
    },
    toggleColumn: function(level, that) {
        var _i = that.find('i').last();

        if (_i.is('.icon-plus-c')) {
            $('.icon-minus-c').removeClass('icon-minus-c').addClass('icon-plus-c');
            _i.removeClass('icon-plus-c').addClass('icon-minus-c');

            $('[column]').hide();
            $('[column="' + level + '"]').show();

        } else {
            $('[column]').hide();
            $('.icon-minus-c').removeClass('icon-minus-c').addClass('icon-plus-c');
        }
        Helper.updateScroll();
    }
});


var RaportFinansowy = new Class({}).extend({
    showChart: function(data, that) {

        DataArray = RaportsChartData;
        var RaportChartName = "";

        Object.each(data, function(key, index) {

            if (index == 0) {
                DataArray = DataArray[key];
                RaportChartName = key;
            } else {
                DataArray = DataArray.items[key];
                RaportChartName += '-' + key;
            }

            Debug.object(DataArray);
        });

        Debug.info("[Raport] RaportChartName : " + RaportChartName);

        Debug.object(DataArray);
        var ChartData = new Array();

        ChartData.points = {
            show: true
        };

        ChartData.lines = {
            show: true,
            lineWidth: 1,
            fill: true,
            fillColor: {
                colors: [{
                        opacity: 0.3
                    }, {
                        opacity: 0.4
                    }]
            }
        };

        ChartData.data = new Array();
        var _y = 0;

        Object.each(DataArray.values, function(Ydata, key) {
            _y++;

            Object.each(Ydata.items, function(data, kw) {
                ChartData.data.push([_y + " / " + kw, Number(data).toFixed(2)]);
            });

        });

        Debug.info("[Raport] Dane do wykresu");
        Debug.object(ChartData);

        $('[chart]').hide();

        if ($('#placeholder_' + RaportChartName)) {

            $.plot("#placeholder_" + RaportChartName, [ChartData], {
                colors: ['#2EA6E6', '#126545', '#ED1E47', '#2DD552', '#EC931E'],
                grid: {
                    hoverable: true
                },
                tooltip: true,
                tooltipOpts: {
                    defaultTheme: false
                },
                yaxis: {
                },
                xaxis: {
                    mode: "categories",
                    tickLength: 0
                }
            });

            var previousPoint = null;
            $('#placeholder_' + RaportChartName).bind("plothover", function(event, pos, item) {
                if (item) {
                    if (previousPoint != item.datapoint) {
                        previousPoint = item.datapoint;

                        $("#flot-tooltip").remove();
                        var x = item.datapoint[0],
                                y = item.datapoint[1] - item.datapoint[2];

                        showTooltip(item.pageX, item.pageY, y, item.series.color);
                    }
                }
                else {
                    $("#flot-tooltip").remove();
                    previousPoint = null;
                }
            });

        } else {
            Debug.warning("[Raport] Nie ma takiego obiektu: [kanwa=" + RaportChartName + "]");
        }

        if (that.attr('data-chart') === 'hidden') {
            $('[chart="' + RaportChartName + '"]').show();
            that.attr('data-chart', 'visible');
        } else {
            that.attr('data-chart', 'hidden');
            $('[chart="' + RaportChartName + '"]').hide();
            $('[row]').css({color: '#00376A'});
        }

        Helper.updateScroll();
        return false;
    },
});

var RaportOperacyjny = new Class({
}).extend({
    showPieChart: function(data, that, RaportChartName) {
        $('[row]').css({color: '#00376A'});

        Debug.info('Raport Operacyjny dane :');
        Debug.object(data);

        Debug.info("[RaportOperacyjny] RaportChartName : " + RaportChartName);

        $('[chart]').hide();

        if ($('#placeholder_' + RaportChartName)) {
            $.plot("#placeholder_" + RaportChartName, data, {
                colors: ['#126545', '#ED1E47', '#2EA6E6', '#2DD552', '#EC931E'],
                series: {
                    pie: { 
                        show: true,
                        innerRadius: 0.5,
                        radius: 1,
                        label: {
                            show: true,
                            radius: 3/4,
                            formatter: function(label, series){ 
                                return '<div style="font-size:11px; opacity: 0.75; text-align:center;padding:2px;color:black; background: white;">'+label+' - '+Math.round(series.percent)+'%</div>'; 
                            },
                            background: { 
                                opacity: 0.5,
                                color: '#000'
                            }
                        }
                    }
                },
                legend: {
                    show: false
                }
            });
        } else {
            Debug.warning("[RaportOperacyjny] Nie ma takiego obiektu: [kanwa=" + RaportChartName + "]");
        }

        if (that.attr('data-chart') === 'hidden') {
            $('[chart="' + RaportChartName + '"]').show();
            that.attr('data-chart', 'visible');
        } else {
            that.attr('data-chart', 'hidden');
            $('[chart="' + RaportChartName + '"]').hide();
            $('[row]').css({color: '#00376A'});
        }

        Helper.updateScroll();
        return false;
    },
    showChart: function(data, that, names) {
        $('[row]').css({color: '#00376A'});

        var DataArray = RaportOperacyjnyChartData;

        Debug.info('Raport Operacyjny dane :');
        Debug.object(DataArray);

        var RaportChartName = "";

        Object.each(data, function(key, index) {
            if (index == 0) {
                DataArray = DataArray[key];
                RaportChartName = key;
            } else {
                DataArray = DataArray[key];
                RaportChartName += '_' + key;
            }
            Debug.object(DataArray);
        });

        Debug.info("[RaportOperacyjny] RaportChartName : " + RaportChartName);

        var ChartData = new Array();
        var ChartLabels = new Array();
        var composite = false;
        var _r = 0;

        var i = 0;
        Object.each(DataArray, function(data, name) {


            if (is_array(data)) {

                if (!isset(ChartData[name])) {
                    ChartData[name] = new Array();
                }

                Debug.info("[RaportOperacyjny] ARRAY - KEY :" + name);
                composite = true;

                ChartData[name].label = names[i];

                ChartData[name].lines = {
                    show: true,
                    lineWidth: 1,
                    fill: true,
                    fillColor: {
                        colors: [{
                                opacity: 0.3
                            }, {
                                opacity: 0.4
                            }]
                    }
                };

                ChartData[name].points = {
                    show: true
                };

                ChartData[name].data = new Array();

                Object.each(data, function(data, key) {
                    var _year = Math.floor((parseInt(key)) / 4) + 1;
                    var _kw = RaportOperacyjny.changeNumberToQuarter(key);
                    var value = parseInt(data);

                    if (isNaN(value)) {
                        value = 0;
                    }

                    ChartData[name].data.push(["" + _year + " / " + _kw, value]);
                });

            } else {
                Debug.info("[RaportOperacyjny] ARRAY :" + name);

                if (!isset(ChartData[RaportChartName])) {
                    ChartData[RaportChartName] = new Array();
                    ChartData[RaportChartName].label = names[i];
                    ChartData[RaportChartName].lines = {
                        show: true,
                        lineWidth: 1,
                        fill: true,
                        fillColor: {
                            colors: [{
                                    opacity: 0.3
                                }, {
                                    opacity: 0.4
                                }]
                        }
                    };

                    ChartData[RaportChartName].points = {
                        show: true
                    };
                    ChartData[RaportChartName].data = new Array();
                }

                var _year = Math.floor((parseInt(_r)) / 4) + 1;
                var _kw = RaportOperacyjny.changeNumberToQuarter(_r);

                var value = parseInt(data);
                if (isNaN(value)) {
                    value = 0;
                }

                ChartData[RaportChartName].data.push(["" + _year + " / " + _kw, value]);
                _r++;
            }
            i++;
        });

        Debug.info("[RaportOperacyjny] Dane do wykresu");
        Debug.object(ChartData);



        $('[chart]').hide();

        if ($('#placeholder_' + RaportChartName)) {

            var data = new Array();

            Object.each(ChartData, function(value, key) {
                data.push(value);
            });

            Debug.info("Dane po konwersji: ");
            Debug.object(data);

            var yaxis = {};

            if (RaportChartName == 'zatrudnienie_liczba_zatrudnionych_administracja' ||
                    RaportChartName == 'zatrudnienie_liczba_zatrudnionych' ||
                    RaportChartName == 'marketing' ||
                    RaportChartName == 'marketing_efektywnosc_marketingu_standard' ||
                    RaportChartName == 'firma_wartosc_zadluzenia' ||
                    RaportChartName == 'marketing_efektywnosc_marketingu_lux' ||
                    RaportChartName == 'zatrudnienie_liczba_zatrudnionych_obsluga'
                    ) {
                yaxis = {min: 0};
            }

            $.plot("#placeholder_" + RaportChartName, data, {
                colors: ['#126545', '#ED1E47', '#2EA6E6', '#2DD552', '#EC931E'],
                grid: {
                    hoverable: true
                },
                tooltip: true,
                tooltipOpts: {
                    defaultTheme: false
                },
                yaxis: yaxis,
                xaxis: {
                    mode: "categories",
                    tickLength: 0
                },
                legend: {
                    position: "nw",
                    margin: [25, 0]
                }
            });

            var previousPoint = null;

            $('#placeholder_' + RaportChartName).bind("plothover", function(event, pos, item) {
                if (item) {
                    if (previousPoint != item.datapoint) {
                        previousPoint = item.datapoint;

                        $("#flot-tooltip").remove();
                        var x = item.datapoint[0],
                                y = item.datapoint[1] - item.datapoint[2];
                        showTooltip(item.pageX, item.pageY, item.series.label + ": " + y, item.series.color);
                    }
                }
                else {
                    $("#flot-tooltip").remove();
                    previousPoint = null;
                }
            });

        } else {
            Debug.warning("[RaportOperacyjny] Nie ma takiego obiektu: [kanwa=" + RaportChartName + "]");
        }

        if (that.attr('data-chart') === 'hidden') {
            $('[chart="' + RaportChartName + '"]').show();
            that.attr('data-chart', 'visible');
        } else {
            that.attr('data-chart', 'hidden');
            $('[chart="' + RaportChartName + '"]').hide();
            $('[row]').css({color: '#00376A'});
        }

        Helper.updateScroll();
        return false;
    },
    changeNumberToQuarter: function(number) {
        var _kw = ((parseInt(number)) % 4);

        _kw = _kw.toString();
        _kw = _kw.replace(0, 'I');
        _kw = _kw.replace(1, 'II');
        _kw = _kw.replace(2, 'III');
        _kw = _kw.replace(3, 'IV');

        return _kw;
    }
});

var raports = new Raport();