$(document).ready(function() {

  function setCookie(c_name, value, exdays)
  {
    var exdate = new Date();
    exdate.setDate(exdate.getDate() + exdays);
    var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
    document.cookie = c_name + "=" + c_value;
  }

  function getCookie(c_name)
  {
    var c_value = document.cookie;
    var c_start = c_value.indexOf(" " + c_name + "=");
    if (c_start == -1)
    {
      c_start = c_value.indexOf(c_name + "=");
    }
    if (c_start == -1)
    {
      c_value = null;
    }
    else
    {
      c_start = c_value.indexOf("=", c_start) + 1;
      var c_end = c_value.indexOf(";", c_start);
      if (c_end == -1)
      {
        c_end = c_value.length;
      }
      c_value = unescape(c_value.substring(c_start, c_end));
    }
    return c_value;
  }

  var cookieInfo = function(op, test) {
    var jsv = 5;
    var n = window.navigator, b;
    this.op = op || {};

    this.op.l = op.l || n["language"] || n["userLanguage"] || document.documentElement.getAttribute("lang") || "en";

    this.op.vsakt = {i: 9, f: 14, o: 12, s: 6, n: 20};
    this.op.vsdefault = {i: 7, f: 3.6, o: 10.6, s: 4, n: 10};
    this.op.vs = op.vs || this.op.vsdefault;

    for (b in this.op.vsakt)
      if (this.op.vs[b] >= this.op.vsakt[b])
        this.op.vs[b] = this.op.vsakt[b] - 0.05;

    if (!op.reminder || op.reminder < 0.1)
      this.op.reminder = 0;
    else
      this.op.reminder = op.reminder || 24;
    this.op.onshow = op.onshow || function(o) {
    };

    this.op.url = op.url || "#";
    this.op.pageurl = op.pageurl || window.location.hostname || "unknown";
    this.op.newwindow = op.newwindow || false;
    this.op.run = test || op.run || false;

    if (window.location.hash == "#test-qi")
      this.op.run = true;

    var i = new Image();

    if (this.op.reminder > 0) {
      var d = new Date(new Date().getTime() + 1000 * 3600 * this.op.reminder);
      document.cookie = 'cookies_info=pause; expires=' + d.toGMTString() + '; path=/';
    }

    var ll = this.op.l.substr(0, 2);
    var languages = "pl,en,fr";

    this.op.url = "/privace-policy";

    var tar = "";

    if (this.op.newwindow)
      tar = ' target="_blank"';


    var t = 'Strona korzysta z plików cookies w celu realizacji usług i zgodnie z <b><a target="' + tar + '" href="' + this.op.url + '">Polityką Plików Cookies</a></b>. Możesz określić warunki przechowywania lub dostępu do plików cookies w Twojej przeglądarce.';

    if (ll == "pl") {
      t = 'Strona korzysta z plików cookies w celu realizacji usług i zgodnie z <b><a target="' + tar + '" href="' + this.op.url + '">Polityką Plików Cookies</a></b>. Możesz określić warunki przechowywania lub dostępu do plików cookies w Twojej przeglądarce.';
      b = 'Akceptuję';
    }

    if (ll == "en") {
      t = 'This site uses cookies to deliver services in accordance with the <b><a target="' + tar + '" href="' + this.op.url + '">Policy cookies</a></b>. You can specify the conditions for storage or access cookies on your browser.';
      b = 'Accept';
    }

    if (ll == "fr") {
      t = 'Ce site utilise des cookies pour fournir des services en conformité avec les <b><a target="' + tar + '" href="' + this.op.url + '">biscuits de la politique</a></b>. Vous pouvez spécifier les conditions de stockage ou d\'accès des cookies sur votre navigateur.';
      b = 'J\'accepte';
    }

    this.op.text = t;
    this.op.btn = b;

    var div = document.createElement("div");

    this.op.div = div;
    div.id = "cookieInfo";
    div.className = "cookieInfo";

    div.innerHTML = '<div>' + this.op.text + '<div id="cookieInfoClose"><div onclick="$(\'#cookieInfo\').css(\'display\',\'none\');" class="close">' + this.op.btn + '</div></div></div>';

    var sheet = document.createElement("style");
    var style =".cookieInfo {z-index:99000; display: none; position: absolute;\
                  width:100%; top:0px; left:0px; text-align: center; \
                  border-bottom:1px solid #D6D6D6; \
                  color: #474646; \
                  background: none repeat scroll 0 0 rgba(255, 255, 255, 0.82); \
                  text-align:left; cursor:pointer; \
                  font-size: 10px;} \
                .cookieInfo div { padding:4px 0px 4px 0px; text-align: center; width: 1060px; margin: 0 auto; } \
                .cookieInfo a,.cookieInfo a:visited {color:#009FD4; text-decoration: underline;} \
                #cookieInfoClose { text-align: center; margin: 1px 0; background: none repeat scroll 0 0 #009FD4; border: medium none; \
                border-radius: 6px 6px 6px 6px; box-shadow: none;color: #FFFFFF !important; display: inline-block; font-size: 11px; font-weight: bold;\
                line-height: 0px; padding: 0px; text-decoration: none;text-shadow: none; width: auto; float: right;} \
                #cookieInfoClose:hover { background: #333333 !important; } \
                #cookieInfoClose div{ color: white; float: left; margin: 0; font-size: 11px; width: 60px; opacity: 1; text-shadow: none; width: 60px; }\n\ ";

    document.body.insertBefore(div, document.body.firstChild);

    document.getElementsByTagName("head")[0].appendChild(sheet);

    try {
      sheet.innerText = style;
      sheet.innerHTML = style;
    }

    catch (e) {
      try {
        sheet.styleSheet.cssText = style;
      }
      catch (e) {
        return;
      }
    }

    var me = this;

    div.onclick = function() {
      if (me.op.newwindow)
        window.open(me.op.url, "_blank");
      else
        window.location.href = me.op.url;
      return false;
    };

    this.op.bodymt = document.body.style.marginTop;

    document.body.style.marginTop = (div.clientHeight) + "px";

    document.getElementById("cookieInfoClose").onclick = function(e) {

      setCookie('cookies_info', 'accepted')
      $('#cookieInfo').fadeOut('slow');

      var e = e || window.event;
      if (e.stopPropagation)
        e.stopPropagation();
      else
        e.cancelBubble = true;
      
      
      document.body.style.marginTop = me.op.bodymt;
      return true;
    }

    op.onshow(this.op);
  }


  var cookie = getCookie('cookies_info');

  if (cookie != 'accepted') {
    var cookieInfo = cookieInfo || {};
    $bu = cookieInfo(cookieInfo);
    $('#cookieInfo').fadeIn('slow');
  }

});
