var InlineEdit = new Class({
  id: 0,
  initialize: function(id, name, culture, availableFields, model) {
    this.id = id;
    this.name = name;
    this.model = model;
    this.culture = culture;
    this.availableFields = availableFields;
  },
  save: function() {
    $('[inline="' + this.id + '"]').modalIndicator();

    this.copyDataToForm();
    return false;
  },
  saveThisForm: function() {
    $("#InlineForm" + this.id).submit();
  },
  setFormFieldsValues: function() {
    var form_name = this.name + "_" + this.culture + "_";
    var id = this.id;
    
    var model = this.model;

    Object.each(this.availableFields, function(value, key) {

      var val = $('[contenteditable="true"][element="'+value+model+'"][inlineid="'+id+'"]').html();
      InlineEdit.setFormFieldsValue(form_name, value, val, id);
    });

    this.saveThisForm();
  },
  copyDataToForm: function() {
    this.setFormFieldsValues();
  },
}).extend({
  setFormFieldsValue: function(form_name, field, value, id) {

    var formField = $("#InlineForm" + id + " #" + form_name + field);
    console.log("#InlineForm" + id + " #" + form_name + field);
    
    // Pasowało by inne widgety porobić, SELEKTY itp. 
    if (typeof value != "undefined") {
      if (formField.is('input')) {
        formField.val(value);
      } else {
        formField.html(value);
      }
    }
  }
});