/**
 * Klasa zawierająca metody do obsługi manageForm
 *
 * @package     manageForm
 * @subpackage  frontendManagement
 */

$(document).ready(function() {
  $('.action-bar').mouseleave(function() {
    $(this).addClass('hide');
  });
});

// Pokazywanie / Ukrywanie menu z linkami po kliknieciu na ikonke opcji
function toggleActionBar(element) {
  var isHidden = $(element).children('.action-bar').hasClass('hide');
  $('.action-bar').toggleClass('hide', true);

  if (isHidden) {
    $(element).children('.action-bar').removeClass('hide');
  }

  $('#wrapper').click();
}

$(document).ready(function() {
  $('.action-bar').mouseleave(function() {
    $(this).addClass('hide');
  });

  $('.shortcode_tab_item_title').click(function() {
    $(this).parents('.shortcode_tabs').find('.shortcode_tab_item_body').removeClass('active');
    $(this).parents('.shortcode_tabs').find('.shortcode_tab_item_title').removeClass('active');
    var whatopen = $(this).attr('data-open');
    $(this).parents('.shortcode_tabs').find('.' + whatopen).addClass('active');
    $(this).addClass('active');
  });
});

/* END - artCmsPlugin - ActionBar */

/* artCmsPlugin - UserActionBar */

function showFMIcons() {
  $('.options-icon').removeClass('hide');

  $('.user-options-container .icon-eye-close').parent().parent().parent().removeClass('hide');
  $('.user-options-container .icon-eye-open').parent().parent().parent().addClass('hide');
}

function hideFMIcons() {
  $('.options-icon').addClass('hide');

  $('.user-options-container .icon-eye-close').parent().parent().parent().addClass('hide');
  $('.user-options-container .icon-eye-open').parent().parent().parent().removeClass('hide');
}

/* END - artCmsPlugin - UserActionBar */

var ManageForm = new Class({
  initialize: function() {
  },
}).extend({
  getRouting: function(params) {
    return 'manage_form_' + params['task'];
  },
  getPopup: function() {
    return '#fm-popup';
  },
  getPopupContent: function() {
    return '#fm-popup .modal-content';
  },
  showFlash: function() {
    window.location.reload();
  },
  startIndicator: function(element) {
    startIndicator(element, 4);
  },
  stopIndicator: function(element) {
    stopIndicator(element, 4);
  },
  changeTab: function(element, tab) {
    $(element).parent().parent().children('.all_body_cont').children('.shortcode_tab_item_body').removeClass('active');
    $(element).parent().find('.shortcode_tab_item_title').removeClass('active');
    $(element).parent().parent().find('.' + tab).addClass('active');
    $(element).addClass('active');
    var activeTab = $(element).parent().parent().parent().find('input[id*=active_tab]')
    if (isset(activeTab)) {
      activeTab.val(tab);
    }
  },
  close: function() {
    $(ManageForm.getPopup()).modal('hide')
    $(ManageForm.getPopup()).remove();
    $('body').css('overflow', 'hidden');
  },
  onSuccess: function(data) {
    
    if (data == 'Success') {
      ManageForm.showFlash();
    } else {
      $(ManageForm.getPopup()).modal('hide')
      $(ManageForm.getPopup()).remove();
      $('body').append(data);
      $(ManageForm.getPopup()).modal('show');
      getCKEInstances();
      $('body').css('overflow', 'visible');

      // Trzeba zrobić jakeđ funcke jak na Hotelu, do takich elementów htmkl co potrzebują JS.
//      $('select').chosen();
    }
  },
  sendAjax: function(element, _url) {
    jQuery.ajax({
      statusCode: {
        301: function(xhr) {
          window.location.assign(xhr.responseText)
        },
        404: function() {
          alert("Nie odnaleziono strony");
        },
        500: function() {
          alert("Wystąpił nieokreslony błąd ! Sprawdź połącznie z internetem. Jeżeli problem nie zostanie rozwiązany skontaktuj się z administratorem strony.");
        }
      },
      type: 'post',
      dataType: 'html',
      beforeSend: function() {
        ManageForm.startIndicator(element);
      },
      success: function(data, textStatus) {
        ManageForm.stopIndicator(element);
        $(ManageForm.getPopup()).modal('hide')
        $(ManageForm.getPopup()).remove();
        $('body').append(data);
        $(ManageForm.getPopup()).modal('show');
        getCKEInstances();
        $('body').css('overflow', 'visible');
//        $('select').chosen();
      },
      url: _url
    });
  },
  menuItemAdd: function(element, menuGroupId, category_id) {
    var params = {"menu_group_id": menuGroupId, "task": "add", "form": "MenuItemForm"};
    if (isset(category_id)) {
      params['category_id'] = category_id;
    }
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuItemEdit: function(element, menuItemId) {
    var params = {"id": menuItemId, "task": "edit", "form": "MenuItemForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuItemDelete: function(element, menuItemId) {
    var params = {"id": menuItemId, "task": "delete", "form": "MenuItemForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuItemListOrder: function(element, id) {
    var params = {"id": id, "task": "list_order", "model": "MenuItem", table_method: "getFmListOrder", "partial": "menuItemListOrder"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  
  menuGroupAdd: function(element, menuItemId) {
    // menuItemId (opcjonalny) - ID obiektu MenuItem do ktorego chcemy przypisac odrazu nowe MenuGroup
    var params = {"task": "add", "form": "MenuGroupForm"};
    if (isset(menuItemId)) {
      params['menu_item_id'] = menuItemId;
    }
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuGroupEdit: function(element, menuGroupId) {
    var params = {"id": menuGroupId, "task": "edit", "form": "MenuGroupForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuGroupDelete: function(element, menuGroupId) {
    var params = {"id": menuGroupId, "task": "delete", "form": "MenuGroupForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  
  articleEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "ArticleForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articleMetaEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "ArticleMetaForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  
  categoryEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "CategoryForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  categoryDelete: function(element, id) {
    var params = {"id": id, "task": "delete", "form": "CategoryForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  categoryLayout: function(element, id, layout_module_id) {
    var params = {"id": id, "layout_module_id": layout_module_id, "task": "edit", "form": "CategoryLayoutForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  
  articlePhotoListOrder: function(element, id) {
    var params = {"id": id, "task": "list_order", "model": "ArticlePhoto", table_method: "getFmListOrder", "partial": "articlePhotoListOrder"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articlePhotoList: function(element, article_id, page) {
    var params = {"article_id": article_id, "task": "list", "model": "ArticlePhoto", table_method: "getFmList", "partial": "articlePhotoList", "max_items": 5, "page": page};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articlePhotoAdd: function(element, article_id) {
    var params = {"article_id": article_id, "task": "add", "form": "ArticlePhotoForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articlePhotoEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "ArticlePhotoForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articlePhotoDelete: function(element, id) {
    var params = {"id": id, "task": "delete", "form": "ArticlePhotoForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articlePhotoDeleteAll: function(element, article_id) {
    var params = {"article_id": article_id, "task": "table_method", "model": "ArticlePhoto", table_method: "fmDeletePhotos", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  
  articleAdd: function(element, articleExample, categoryId) {
    var params = {"task": "add", "form": "ArticleForm", "isNarrow": 1};
    if (isset(categoryId)) {
      params['category_id'] = categoryId;
    }
    if (isset(articleExample)) {
      params['article_example'] = articleExample;
    }
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articleDelete: function(element, id) {
    var params = {"id": id, "task": "delete", "form": "ArticleForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  commentEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "ArticleCommentForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  commentDelete: function(element, id) {
    var params = {"id": id, "task": "delete", "form": "ArticleCommentForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  articleLayoutEdit: function(element, id, layout_module_id) {
    var params = {"id": id, "layout_module_id": layout_module_id, "task": "edit", "form": "ArticleLayoutForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },

  menuItemOrderUp: function(element, menuItemId) {
    var params = {"id": menuItemId, "task": "order", "move": "right", "form": "MenuItemOrderForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  menuItemOrderDown: function(element, menuItemId) {
    var params = {"id": menuItemId, "task": "order", "move": "left", "form": "MenuItemOrderForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  artConfigurationList: function(element, page) {
    var params = {"task": "list", "model": "ArtConfiguration", table_method: "getFmList", "partial": "artConfigurationList", "max_items": 5, "page": page};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  artConfigurationEdit: function(element, id) {
    var params = {"id": id, "task": "edit", "form": "ArtConfigurationForm"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  changePassword: function(element, userId) {
    var params = {"id": userId, "task": "edit", "form": "sfGuardChangeSigninPasswordForm", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
  login: function(element) {
    // task = add, dlatego ze form nie potrzebuje obiektu
    var params = {"task": "add", "form": "sfGuardFormSignin", "isNarrow": "1"};
    ManageForm.sendAjax(element, Routing.generate(ManageForm.getRouting(params), params));
  },
});