/* artCmsPlugin - ActionBar */

// Pokazywanie / Ukrywanie menu z linkami po kliknieciu na ikonke opcji
function toggleActionBar(element){
  var isHidden = $(element).parent().children('.action-bar').hasClass('hide');
  $('.action-bar').toggleClass('hide', true);

  if (isHidden) {
    $(element).parent().children('.action-bar').removeClass('hide');
  }

  $('#wrapper').click();
}

$(document).ready(function(){
  $('.action-bar').mouseleave(function(){
    $(this).addClass('hide');
  });
});

/* END - artCmsPlugin - ActionBar */

/* artCmsPlugin - UserActionBar */

function showFMIcons(){
  $('.options-icon').removeClass('hide');

  $('.user-options-container .icon-eye-close').parent().parent().parent().removeClass('hide');
  $('.user-options-container .icon-eye-open').parent().parent().parent().addClass('hide');
}

function hideFMIcons(){
  $('.options-icon').addClass('hide');

  $('.user-options-container .icon-eye-close').parent().parent().parent().addClass('hide');
  $('.user-options-container .icon-eye-open').parent().parent().parent().removeClass('hide');
}

/* END - artCmsPlugin - UserActionBar */

function enableCKE(width, height,minWidth, minHeight)
{
  $('div.no-ckeditor textarea').addClass('no-ckeditor');

  $('textarea:not(.no-ckeditor)').each(function(){
    id=$(this).attr('id');
    var instance = CKEDITOR.instances[id];
    if(instance)
      CKEDITOR.remove(instance);
  
    CKEDITOR.replace(id,{
      height: minHeight,
      width: minWidth
    });

    var new_instance = CKEDITOR.instances[id];

    CKEDITOR.config.resize_maxHeight = height;
    CKEDITOR.config.resize_maxWidth = width;
    CKEDITOR.config.resize_minHeight = minHeight;
    CKEDITOR.config.resize_minWidth = minWidth;
    CKEDITOR.config.contentsCss = '/css/cke-articles.css';
    CKEDITOR.config.bodyClass = CKEDITOR.config.bodyClass + ' cke-article-text';


    new_instance.on('blur',function () {
      CKEDITOR.instances[id].updateElement()
    })
  });
}

function getCKEInstances(){
  enableCKE(400, 200, 700, 300);
}

function updateCKE(){
  for (var id in CKEDITOR.instances)
    if (document.getElementById(id))
      CKEDITOR.instances[id].updateElement();
}


function initSimpleCKE(width, height,minWidth, minHeight) {
  $('div.no-ckeditor textarea').addClass('no-ckeditor');

  $('textarea:not(.no-ckeditor)').each(function(){
      
    id=$(this).attr('id');
    var instance = CKEDITOR.instances[id];
    if(instance) {
      CKEDITOR.remove(instance);
    }

    CKEDITOR.replace(id,{
      toolbar: 'Simple',
      height: minHeight,
      width: minWidth
    });

    var new_instance = CKEDITOR.instances[id];

    CKEDITOR.config.resize_maxHeight = height;
    CKEDITOR.config.resize_maxWidth = width;
    CKEDITOR.config.resize_minHeight = minHeight;
    CKEDITOR.config.resize_minWidth = minWidth;
    CKEDITOR.config.contentsCss = '/css/cke-articles.css';
    CKEDITOR.config.bodyClass = CKEDITOR.config.bodyClass + ' cke-article-text';

    new_instance.on('blur',function () {
      CKEDITOR.instances[id].updateElement()
    })
  });
}


$.extend($.ui.dialog.overlay, { create: function(dialog){
	if (this.instances.length === 0) {
		// prevent use of anchors and inputs
		// we use a setTimeout in case the overlay is created from an
		// event that we're going to be cancelling (see #2804)
		setTimeout(function() {
			// handle $(el).dialog().dialog('close') (see #4065)
			if ($.ui.dialog.overlay.instances.length) {
				$(document).bind($.ui.dialog.overlay.events, function(event) {
					var parentDialog = $(event.target).parents('.ui-dialog');
					if (parentDialog.length > 0) {
						var parentDialogZIndex = parentDialog.css('zIndex') || 0;
						return parentDialogZIndex > $.ui.dialog.overlay.maxZ;
					}
					
					var aboveOverlay = false;
					$(event.target).parents().each(function() {
						var currentZ = $(this).css('zIndex') || 0;
						if (currentZ > $.ui.dialog.overlay.maxZ) {
							aboveOverlay = true;
							return;
						}
					});
					
					return aboveOverlay;
				});
			}
		}, 1);
		
		// allow closing by pressing the escape key
		$(document).bind('keydown.dialog-overlay', function(event) {
			(dialog.options.closeOnEscape && event.keyCode
					&& event.keyCode == $.ui.keyCode.ESCAPE && dialog.close(event));
		});
			
		// handle window resize
		$(window).bind('resize.dialog-overlay', $.ui.dialog.overlay.resize);
	}
	
	var $el = $('<div></div>').appendTo(document.body)
		.addClass('ui-widget-overlay').css({
		width: this.width(),
		height: this.height()
	});
	
	(dialog.options.stackfix && $.fn.stackfix && $el.stackfix());
	
	this.instances.push($el);
	return $el;
}});

 
function getPopupElement() {
  return $('#popup');
}

function getGlobalIndicatorElement() {
  return $('#global-indicator');
}


function popupClose() {
  getPopupElement().remove();
}

function showGlobalIndicator() {
  getGlobalIndicatorElement().removeClass('hide');
  getGlobalIndicatorElement().modalIndicator();
}

function hideGlobalIndicator() {
  getGlobalIndicatorElement().addClass('hide');
  getGlobalIndicatorElement().modalIndicator('close');
}

function startIndicator(element, depth) {
  if (typeof depth === 'undefined') { depth = false };
  // Jesli nie podalismy elementu lub jest nim globalIndicator to pokaz globalIndicator
  if (typeof element === 'undefined' || getGlobalIndicatorElement()[0] == element[0]) { showGlobalIndicator() };
  if (! ($(element).length > 0 ) ) {
    return;
  }
  
  // Sprawdzenie czy element jest popupem lub depth jest false
  if (!depth || getPopupElement()[0] == element[0]) {
    $(element).modalIndicator();
  } else {
    if ($(element).hasClass('indicator')) {
      $(element).modalIndicator();
    } else if (depth > 1) {
      startIndicator($(element).parent(), depth - 1);
    }
  }
}

function stopIndicator(element, depth) {
  if (typeof depth === 'undefined') {depth = false};
  // Jesli nie podalismy elementu lub jest nim globalIndicator to schowaj globalIndicator
  if (typeof element === 'undefined' || getGlobalIndicatorElement()[0] == element[0]) { hideGlobalIndicator() };
  if (! ($(element).length > 0 ) ) {
    return;
  }
  
  if (!depth || getPopupElement()[0] == element[0]) {
    $(element).modalIndicator('close');
  } else {
    if ($(element).hasClass('indicator')) {
      $(element).modalIndicator('close');
    } else if (depth > 1) {
      stopIndicator($(element).parent(), depth - 1);
    }
  }
}

function newDialog(popupDivId, data, title, dialogWidth, dialogHeight){
    var dWidth = typeof(dialogWidth) != 'undefined' ? dialogWidth : 'auto';
    var dHeight = typeof(dialogHeight) != 'undefined' ? dialogHeight : 'auto';

    if (!document.getElementById(popupDivId))
        $("body").append('<div id="' + popupDivId + '"></div>');
    else
        $('#'+ popupDivId).html('');

    $('#' + popupDivId).dialog({
        modal : true,
        width: dWidth,
        height: dHeight,
        title: title,
        close: function(event, ui){
            $(this).dialog("destroy");
        },
        destroy: function(event, ui){
            $('#' + popupDivId).remove();
        }
    });

    $('#' + popupDivId).html(data);
}