(function( $ ) {
  var imgDivElement;
  var modalElement;
  var indicatorElement;
  var imgObject = new Image();
  var imgPath;
  var settings = new Object();
  var modalIndicatorElement;
  var modalDiv = '';
  
  var methods = {
    init : function( options) { 
      modalIndicatorElement = this;
      settings = $.extend( {
        modal: true,
        withWindowEvents : true,
        view: '4',
        image: null,
        imageAbsolutePath: null,
        color: 'black-transparent',
        opacity: 0.1
      }, options);

      this.modalIndicator('close');
      
      var pluginImgPath = '/arteneo-theme/images/modalIndicator/';
      
      if (settings.imageAbsolutePath != null)
        imgPath = settings.imageAbsolutePath;
      else if (settings.image != null)
        imgPath = pluginImgPath + settings.image;
      else
        imgPath = pluginImgPath + settings.color + '-indicator' + settings.view + '.gif';
        
      imgObject.src = imgPath;
      
      if (settings.modal)
        modalDiv = '<div class="art-modal-indicator-glass" style="position: absolute; z-index: 1000;"></div>';
      
      var imgDiv = '<div class="art-modal-indicator-img" style="position: absolute; z-index: 1001;"><img src="' + imgPath + '" alt="" /></div>';
      this.append('<div class="art-modal-indicator" style="position:absolute; top: 0; left: 0;">' + imgDiv + modalDiv + '</div>');

      indicatorElement = this.find('.art-modal-indicator');
      imgDivElement = this.find('.art-modal-indicator-img');
      
      if (settings.modal){
        modalElement = this.find('.art-modal-indicator-glass');
        modalElement.css('opacity', settings.opacity);
     }
      
      this.modalIndicator('setImageDimensions');
      
      if (settings.withWindowEvents)
      {
        $(window).bind('scroll', function() {
          modalIndicatorElement.modalIndicator('setImageDimensions');
        });
        $(window).bind('resize', function() {
          modalIndicatorElement.modalIndicator('setImageDimensions');
        });
      }
    },
    
    setImageDimensions: function( ) {
      imgDivElement.width(imgObject.width);
      imgDivElement.height(imgObject.height);
      
      if (settings.modal){
        modalElement.width(this.outerWidth());
        modalElement.height(this.outerHeight());
      }
      
      var elementHeight = this.outerHeight();
      var windowWidth = $(window).width();
      var windowScroll = $(window).scrollTop();
      var elementOffsetTop = 0;
      
      if (this.offset() != null)
        elementOffsetTop = this.offset().top;
      
      var windowHeight = $(window).height();

      if(!(this.css('position') == 'absolute' || this.css('position') == 'relative'))
        this.css('position', 'relative');
      
      var elementVisibleWidth = this.outerWidth();
      var elementVisibleHeight;
      var elementCutHeight = 0;

      //jeżeli nie widać góry elementu
      if (windowScroll > elementOffsetTop)
      {
        elementVisibleHeight = elementHeight + elementOffsetTop - windowScroll;
        elementCutHeight = elementHeight - elementVisibleHeight;

        if (elementVisibleHeight > windowHeight) //jeżeli nie widać dołu elementu
          elementVisibleHeight = windowHeight;
      }
      else //jeżeli widać góre elementu
      {
        elementVisibleHeight = windowHeight - elementOffsetTop + windowScroll;

        if (elementVisibleHeight > elementHeight) //jeżeli widać dół elementu
          elementVisibleHeight = elementHeight;
      }

      if (elementVisibleWidth > windowWidth)
        elementVisibleWidth = windowWidth;
      
      imgDivElement.css('left', parseInt((elementVisibleWidth - imgObject.width) / 2));
      imgDivElement.css('top', parseInt((elementVisibleHeight - imgObject.height) / 2) + elementCutHeight);
    },
    
    close: function( ) {
      if (this.find('.art-modal-indicator').length > 0)
        this.find('.art-modal-indicator').remove();
    }
  };
  
  $.fn.modalIndicator = function(method) {
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on modalIndicator.' );
    }    
  };
})( jQuery );