/**
 * Klasa zawierająca Konfiguracje ENGINU
 *
 * @package     sfJSPlugin
 * @subpackage  core

 * @version     0.1-DEV
 * @type {Class}
 */
var Config = new Class({
  initialize: function() {

  }
}).extend({
  /**
   * Zwraca true / false. Włącza wyłącza wyświetlanie logów w konsoli.
   *
   * @return {Boolean}
   */
  debug: true,
  /**
   * Ustawia główną ścieżkę z plikami JS w katalogu web.
   */
  rootPath: '/js/game',
  /**
   * Ustawia katalog z modułami. 
   */
  modulesPath: '/js/game/app/modules',
  /**
   * Zwraca wersję Pluginu.
   *
   * @return {Number}
   */
  getVersion: function() {
    return 0.5;
  },
});

if (Config.debug) {

  var browserName = navigator.appName;
  if (browserName == "Microsoft Internet Explorer") {
    console.log('INICJALIZACJA ENGINE ' + Config.getVersion() + ' : Arteneo - 2013 ');
    console.log('Aby wyświetlić pomoc skorzystaj z polecnia: Help.show(); ');
    console.log('Aby wyłączyć debugowanie zmień zmienną Config.debug; aby zwracała "false"; ');
  } else {
    console.log('%cINICJALIZACJA ENGINE ' + Config.getVersion() + ' : Arteneo - 2013 ', 'font-weight: bold; color:#32094C;  font-style: italic; font-size: 18px;');
    console.log('%c Aby wyświetlić pomoc skorzystaj z polecnia: %c Help.show(); ', 'color:#EE4433;', 'font-weight: bold;');
    console.log('%c Aby wyłączyć debugowanie zmień zmienną Config.debug; aby zwracała "false"; ', 'color:#EE4433;');
  }

}
