/**
 * Klasa zawierająca metody do obsługi Routingu;
 *
 * @package     sfJSPlugin
 * @subpackage  core

 * @version     0.1-DEV
 * @type {Class}
 */

// Kompilatorek w PHP, do tworzenia ostatecznego pliku z JS. (V)
// Zrobić gotowe komponenty:
// > Tooltip (V)
// > Popup (V)
// > Indicator (V)
// Zrobić porządek z pluginami JQuery | JQuery UI | Bootstrap | itp. (V)
// Pobranie zmiennych z sesji do JS. 
// Stworzenie oddzielnej konfiguracji, jak APP, dla JS. 
// I18N, wyciaganie wartości dla dowolnego z językow, baz zmian języka w sesji uzytkownika.
// Usprawanie AJAX. itp. 
// Pobieranie zmiennych z APP | oznaczonych jako do podglądu w JS.
// Pobieranie danych z sesji użytkownika.


var CoreTime = new Date();

var CoreTimer = new Class({
}).extend({
  timestamp: function() {
    return new Date().getTime();
  },
  tabTime: function() {
    return CoreTime.getTime();
  },
  tabTimestamp: function() {

    return MD5(CoreTimer.tabTime().toString());
  }
});

// Camelize jak w PHP
jQuery.extend(String.prototype, {
  camelize: function() {
    return this.replace(/(?:^|[-_])(\w)/g, function(_, c) {
      return c ? c.toUpperCase() : '';
    })
  }, 
  camelizeWithSpaces: function() {
    var string = this.replace(/(?:^|[-_])(\w)/g, function(_, c) {
      return c ? c.toUpperCase() : '';
    }); 
    
    return string.replace(/([a-z])([A-Z])/g, '$1 $2'); 
  }, 
  
});


$.RoutingClass = $.RoutingClass || {};

(function(Routing, $, undefined) {

  $.extend(Routing, (function() {

    /**
     * Zmienne, wyrażenia regularne.
     *
     * @type {Object}
     * @private
     */
    var _routes = {},
            _defaults = {},
            rquery = /\?/,
            rabsurl = /^\//,
            rescregexp = /[-[\]{}()*+?.,\\^$|#\s]/g,
            rdblslash = /\/\//g,
            self = Routing,
            ServerMethods = {};

    /**
     * Przygotowuje wyrażenie regularne.
     *
     *    regexify('a'); // zwraca 'a'
     *    regexify(['a', '.']); // zwraca 'a|\.'
     *    regexify(['a', '.'], '$'); // zwraca 'a|\.|$'
     *
     * @param {Array|string}
     * @param {String}
     * @return {String}
     */
    function regexify(separators, unescaped) {
      var i, _separators = [];

      // Sprawdź czy seperatory sa w tablicy.
      if (!$.isArray(separators)) {
        separators = [separators];
      }

      // Wykonuje dla każdego seperatora regexp.
      for (i in separators) {
        _separators[i] = separators[i].toString().replace(rescregexp, '\\$&');
      }

      if (unescaped) {
        _separators.push(unescaped);
      }

      if (_separators.length > 1) {
        return _separators.join('|')
      } else if (_separators.length) {
        return _separators[0];
      }

      return '';
    }
    ;

    /**
     * Podmienia parametry w podanym adresie URL, Uzyte parametry wyrzuca z tablicy.
     *
     * @param {String}
     * @param {Object}
     * @return {String}
     */
    function replace_params(url, params) {
      var i,
              _url = url,
              separators = self.segmentSeparators,
              prefixes = regexify(self.variablePrefix),
              suffixes = regexify(self.variableSuffix),
              prefix = '(' + regexify(separators, '^') + ')' + prefixes,
              suffix = suffixes + '(' + regexify(separators, '$') + ')';

      for (i in params) {

        var r = new RegExp(prefix + i + suffix, '');

        if (r.test(_url)) {
          _url = _url.toString().replace(r, '$1' + params[i] + '$2');
          delete(params[i]);
        }
      }

      return _url;
    }
    ;

    /**
     * Metody wysyłające request do serwera.
     * get, put,  post, del
     *
     * @param {String}    route_id    nazwa routingu do wygenerowania adresu.
     * @param {Object}    [params]    parametry do routingu.
     * @param {Function}  [callback=success(data, textStatus, jqXHR)] Zwrócone dane  z requesta.
     * @param {String}    [type]
     * @api public
     */

    $(["get", "post"]).each(function(i, method) {
      ServerMethods[method] = function(route_id, data, callback, type) {

        // Przepisanie argumentów jeśli nie podano obj. data.
        if ($.isFunction(data)) {
          type = type || callback;
          callback = data;
          data = undefined;
        }

        return $[method](self.generate(route_id, data, false), data, callback, type);
      }
    });

    $(["put", "delete"]).each(function(i, method) {
      ServerMethods[method.substr(0, 3)] = function(route_id, data, callback, type) {
        var _data = {};
        _data[self.methodParameterName] = method;

        // Przepisanie argumentów jeśli nie podano obj. data.
        if ($.isFunction(_data)) {
          type = type || callback;
          callback = _data;
          data = undefined;
        }

        _data = $.extend(_data, data || {});
        return $.post(self.generate(route_id, _data, false), _data, callback, type);
      }
    });

    return $.extend(ServerMethods, {
      /**
       * Domyślne parametry dla każdej z tras.
       */
      defaults: {},
      /**
       * Domyślny suffix.
       */
      variableSuffix: '',
      /**
       * Prefiks parametrów routingu.
       */
      variablePrefix: ':',
      /**
       * Tablica domyślnych seperatorów.
       */
      segmentSeparators: ['/', '.'],
      /**
       * Domyslny prefiks dla URL trasy.
       */
      prefix: '',
      /**
       * Domyslny klucz CSRF.
       */
      
      csrf: {},
      /**
       * Nazwa parametru używana dla HTTP 1,0
       */
      methodParameterName: 'sf_method',
      /**
       * Połącznie Route.
       *
       * @param {String} , nazwa trasy.
       * @param {String} , wzorzec url
       * @return {Object}  Routing.
       */
      connect: function(id, pattern, defaults) {
        _routes[id] = pattern;
        _defaults[id] = defaults || {};
        return self;
      },
      /**
       * Zwraca trase po nazwie , id.
       *
       * @param {String} , nazwa trasy
       * @return {String} , trasa.
       */
      getRoute: function(route_id) {
        return _routes[route_id] || undefined;
      },
      /**
       * Sprawcza czy trasa jest dostepna.
       *
       * @param {String} , nazwa trasy.
       * @return {Boolean} true / false.
       */
      has: function(route_id) {
        return (_routes[route_id] ? true : false);
      },
      /**
       * Czyści listę tras, routing.
       *
       * @return {Object} Routing.
       */
      flush: function() {
        _routes = {};
        _defaults = {};
        return self;
      },
      /**
       *Generuje URL dla podanej nazwy trasy.
       *
       * @param {String} , nazwa trasy.
       * @param {Object} , tablica z parametrami.
       * @param {Boolean} , true / false. Dorzucenie dodatkowych parametrów nie zdefiniowanych w tablicy routingu.
       * @return {String} , wygenerowany URL
       */
      generate: function(route_id, params, withExtraParameters) {
        var _route = self.getRoute(route_id),
                _queryString,
                _url = _route;

        if (!_url) {
          throw Debug.error('[Core][Routing] Nie znalezniono drogi dla : ' + route_id);
        }

        _url = replace_params(_url, params);
        _url = replace_params(_url, $.extend({},
                self.defaults || {},
                _defaults[route_id] || {}));

        if (withExtraParameters || undefined === withExtraParameters) {
          _queryString = $.param(params || {});

          if (_queryString.length) {
            _url += (rquery.test(_url) ? '&' : '?') + _queryString;
          }
        }

        _url = (rabsurl.test(_url) ? '' : '/') + _url;
        _url = self.prefix + _url;
        _url = (rabsurl.test(_url) ? '' : '/') + _url;

        return _url.toString().replace(rdblslash, '/');
      }
    });
  })());
})($.RoutingClass, jQuery);

/**
 * Klasa zawierająca metody do wczytywania innych plików. JavaScript, CSS, Images
 *
 * @type {Class}
 */
var AutoLoad = {
  initialized: false,
  /**
   * Ładuje pliki JS poprzez JS. Na poczatku pobiera plik COnfig, pózniej pozostałe ze zdefiniowanej listy w obiekcie JS.
   *
   * @param files
   * @param iterate
   */
  loader: function(files, iterate) {
    var keys = Object.keys(files);

    if (iterate < Object.getLength(files)) {

      var id = keys[iterate];
      var value = files[id];
      var iterate = iterate.toInt();

      var script = AutoLoad.javascript(value, {
        id: id,
        onLoad: function() {
          Debug.info('[Core][AutoLoad] ' + iterate.toInt() + 1 + '. ' + this.id + '.js is loaded! ');
          AutoLoad.loader(files, iterate.toInt() + 1);
        },
        onError: function() {
          Debug.error('[Core][AutoLoad] ' + this.id + '/js is not loaded!');
          var errors = true;
          AutoLoad.loader(files, iterate.toInt() + 1);
        }
      });
    }
  },
  /**
   * Dodaje plik JS do strony.
   *
   * @param source
   * @param properties
   * @return {*}
   */
  javascript: function(source, properties) {
    if (!properties)
      properties = {};

        var script = new Element('script', {src: source, type: 'text/javascript'}),
    doc = properties.document || document,
            load = properties.onload || properties.onLoad,
            onerror = properties.onerror || properties.onError;

    delete properties.onload;
    delete properties.onLoad;
    delete properties.document;
    delete properties.onerror;
    delete properties.onError;

    if (load) {
      if (typeof script.onreadystatechange != 'undefined') {
        script.addEvent('readystatechange', function() {
          if (['loaded', 'complete'].contains(this.readyState))
            load.call(this);
        });
      } else {
        script.addEvent('load', load);
      }
    }

    if (onerror) {
      if (typeof script.onreadystatechange != 'undefined') {
        script.addEvent('readystatechange', function() {
          if (['loaded', 'complete'].contains(this.readyState))
            onerror.call(this);
        });
      } else {
        script.addEvent('error', onerror);
      }
    }

    return script.set(properties).inject(doc.head);
  },
  /**
   * Dodaje plik CSS do strony.
   *
   * @param source
   * @param properties
   * @return {*}
   */
  css: function(source, properties) {
    if (!properties)
      properties = {};

    var link = new Element('link', {
      rel: 'stylesheet',
      media: 'screen',
      type: 'text/css',
      href: source
    });

    var load = properties.onload || properties.onLoad,
            doc = properties.document || document;

    delete properties.onload;
    delete properties.onLoad;
    delete properties.document;

    if (load)
      link.addEvent('load', load);
    return link.set(properties).inject(doc.head);
  },
  /**
   * Dodaje obrazek do strony.
   *
   * @param source
   * @param properties
   * @return {*}
   */
  image: function(source, properties) {
    if (!properties)
      properties = {};

    var image = new Image(),
            element = document.id(image) || new Element('img');

    ['load', 'abort', 'error'].each(function(name) {
      var type = 'on' + name,
              cap = 'on' + name.capitalize(),
              event = properties[type] || properties[cap] || function() {
      };

      delete properties[cap];
      delete properties[type];

      image[type] = function() {
        if (!image)
          return;
        if (!element.parentNode) {
          element.width = image.width;
          element.height = image.height;
        }
        image = image.onload = image.onabort = image.onerror = null;
        event.delay(1, element, element);
        element.fireEvent(name, element, 1);
      };
    });

    image.src = element.src = source;
    if (image && image.complete)
      image.onload.delay(1);
    return element.set(properties);
  },
  /**
   * Dodaje wiele obrazków do strony.
   *
   * @param sources
   * @param options
   * @return {Elements}
   */
  images: function(sources, options) {
    sources = Array.from(sources);

    var fn = function() {
    },
            counter = 0;

    options = Object.merge({
      onComplete: fn,
      onProgress: fn,
      onError: fn,
      properties: {}
    }, options);

    return new Elements(sources.map(function(source, index) {
      return AutoLoad.image(source, Object.append(options.properties, {
        onload: function() {
          counter++;
          options.onProgress.call(this, counter, index, source);
          if (counter == sources.length)
            options.onComplete();
        },
        onerror: function() {
          counter++;
          options.onError.call(this, counter, index, source);
          if (counter == sources.length)
            options.onComplete();
        }
      }));
    }));
  }
};

/**
 * Klasa z Metodami do obsługi konsoli.
 *
 * @type {*}
 */
var Console = new Class({
  initialize: function() {

  }
}).extend({
  /**
   * Czyści konsolę, w kazdej przeglądarce,
   */
  clear: function() {
    if (typeof console._commandLineAPI !== 'undefined') {
      console.API = console._commandLineAPI;
    } else if (typeof console._inspectorCommandLineAPI !== 'undefined') {
      console.API = console._inspectorCommandLineAPI;
    } else if (typeof console.clear !== 'undefined') {
      console.API = console;
    }

    console.API.clear()
  }
});

/**
 * Spinner.
 */
(function($) {
  $.fn.spin = function(opts, color) {
    var presets = {
      "tiny": {lines: 8, length: 2, width: 2, radius: 3},
      "small": {lines: 8, length: 4, width: 3, radius: 5},
      "large": {lines: 10, length: 8, width: 4, radius: 8}
    };
    if (Spinner) {
      return this.each(function() {
        var $this = $(this),
                data = $this.data();
        if (data.spinner) {
          data.spinner.stop();
          delete data.spinner;
        }
        if (opts !== false) {
          if (typeof opts === "string") {
            if (opts in presets) {
              opts = presets[opts];
            } else {
              opts = {};
            }
            if (color) {
              opts.color = color;
            }
          }
          data.spinner = new Spinner($.extend({color: $this.css('color')}, opts)).spin(this);
        }
      });
    } else {
      Debug.error("[Core][Spinner] Klasa Spinner jest niedostepna, używasz już takiej zmiennej/funkcji ? ");
    }
  };
})(jQuery);

$.fn.unspin = function(callback) {
  this.each(function() {
    var $this = $(this),
            data = $this.data();

    if (data.spinner) {
      data.spinner.stop();
      delete data.spinner;
    }
  });
  return this;
}

var Color = new Class({
}).extend({
  getRandomColor: function(key) {
      
    var colors = ['#126545','#ED1E47', '#2EA6E6', '#2DD552', '#EC931E'];
    
    if (isset(key) && isset(colors[key])){
        return colors[key];
    }
      
    var letters = '0123456789ABCDEF'.split('');
    var color = '#';
    for (var i = 0; i < 6; i++) {
      color += letters[Math.round(Math.random() * 15)];
    }
    return color;
  },
  
  colorLuminance: function(hex, lum) {
    hex = String(hex).replace(/[^0-9a-f]/gi, '');
    if (hex.length < 6) {
      hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
    }
    lum = lum || 0;
    var rgb = "#", c, i;
    for (i = 0; i < 3; i++) {
      c = parseInt(hex.substr(i * 2, 2), 16);
      c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
      rgb += ("00" + c).substr(c.length);
    }
    return rgb;
  },
  hexToRgb: function(hex) {
    hex = hex.replace('#', '');
    r = parseInt(hex.substring(0, 2), 16);
    g = parseInt(hex.substring(2, 4), 16);
    b = parseInt(hex.substring(4, 6), 16);

    result = 'rgb(' + r + ',' + g + ',' + b + ')';
    return result;
  },
  hexToRgba: function(hex, opacity) {
    hex = hex.replace('#', '');
    r = parseInt(hex.substring(0, 2), 16);
    g = parseInt(hex.substring(2, 4), 16);
    b = parseInt(hex.substring(4, 6), 16);

    result = 'rgba(' + r + ',' + g + ',' + b + ',' + opacity / 100 + ')';
    return result;
  }
});


function is_array(mixed_var) {
  _getFuncName = function(fn) {
    var name = (/\W*function\s+([\w\$]+)\s*\(/).exec(fn);
    if (!name) {
      return '(Anonymous)';
    }
    return name[1];
  },
          _isArray = function(mixed_var) {
    if (!mixed_var || typeof mixed_var !== 'object' || typeof mixed_var.length !== 'number') {
      return false;
    }
    var len = mixed_var.length;
    mixed_var[mixed_var.length] = 'bogus';
    if (len !== mixed_var.length) {
      mixed_var.length -= 1;
      return true;
    }
    delete mixed_var[mixed_var.length];
    return false;
  };

  if (!mixed_var || typeof mixed_var !== 'object') {
    return false;
  }

  this.php_js = this.php_js || {};
  this.php_js.ini = this.php_js.ini || {};

  ini = this.php_js.ini['phpjs.objectsAsArrays'];

  return _isArray(mixed_var) ||
          ((!ini || (
                  (parseInt(ini.local_value, 10) !== 0 && (!ini.local_value.toLowerCase || ini.local_value.toLowerCase() !== 'off')))
                  ) && (
                  Object.prototype.toString.call(mixed_var) === '[object Object]' && _getFuncName(mixed_var.constructor) === 'Object'
                  ));
}

function is_object(mixed_var) {

  if (Object.prototype.toString.call(mixed_var) === '[object Array]') {
    return false;
  }
  return mixed_var !== null && typeof mixed_var === 'object';
}

function isset(variable) {
  var a = arguments,
          l = a.length,
          i = 0,
          undef;

  if (l === 0) {
    throw new Error('Empty isset');
  }

  while (i !== l) {
    if (a[i] === undef || a[i] === null) {
      return false;
    }
    i++;
  }
  return true;
}

function is_null (mixed_var) {
  return (mixed_var === null);
}


function var_dump () {
  var output = '',
    pad_char = ' ',
    pad_val = 4,
    lgth = 0,
    i = 0,
    d = this.window.document;
  var _getFuncName = function (fn) {
    var name = (/\W*function\s+([\w\$]+)\s*\(/).exec(fn);
    if (!name) {
      return '(Anonymous)';
    }
    return name[1];
  };

  var _repeat_char = function (len, pad_char) {
    var str = '';
    for (var i = 0; i < len; i++) {
      str += pad_char;
    }
    return str;
  };
  var _getInnerVal = function (val, thick_pad) {
    var ret = '';
    if (val === null) {
      ret = 'NULL';
    } else if (typeof val === 'boolean') {
      ret = 'bool(' + val + ')';
    } else if (typeof val === 'string') {
      ret = 'string(' + val.length + ') "' + val + '"';
    } else if (typeof val === 'number') {
      if (parseFloat(val) == parseInt(val, 10)) {
        ret = 'int(' + val + ')';
      } else {
        ret = 'float(' + val + ')';
      }
    }

    else if (typeof val === 'undefined') {
      ret = 'undefined';
    } else if (typeof val === 'function') {
      var funcLines = val.toString().split('\n');
      ret = '';
      for (var i = 0, fll = funcLines.length; i < fll; i++) {
        ret += (i !== 0 ? '\n' + thick_pad : '') + funcLines[i];
      }
    } else if (val instanceof Date) {
      ret = 'Date(' + val + ')';
    } else if (val instanceof RegExp) {
      ret = 'RegExp(' + val + ')';
    } else if (val.nodeName) { 
      switch (val.nodeType) {
      case 1:
        if (typeof val.namespaceURI === 'undefined' || val.namespaceURI === 'http://www.w3.org/1999/xhtml') { // Undefined namespace could be plain XML, but namespaceURI not widely supported
          ret = 'HTMLElement("' + val.nodeName + '")';
        } else {
          ret = 'XML Element("' + val.nodeName + '")';
        }
        break;
      case 2:
        ret = 'ATTRIBUTE_NODE(' + val.nodeName + ')';
        break;
      case 3:
        ret = 'TEXT_NODE(' + val.nodeValue + ')';
        break;
      case 4:
        ret = 'CDATA_SECTION_NODE(' + val.nodeValue + ')';
        break;
      case 5:
        ret = 'ENTITY_REFERENCE_NODE';
        break;
      case 6:
        ret = 'ENTITY_NODE';
        break;
      case 7:
        ret = 'PROCESSING_INSTRUCTION_NODE(' + val.nodeName + ':' + val.nodeValue + ')';
        break;
      case 8:
        ret = 'COMMENT_NODE(' + val.nodeValue + ')';
        break;
      case 9:
        ret = 'DOCUMENT_NODE';
        break;
      case 10:
        ret = 'DOCUMENT_TYPE_NODE';
        break;
      case 11:
        ret = 'DOCUMENT_FRAGMENT_NODE';
        break;
      case 12:
        ret = 'NOTATION_NODE';
        break;
      }
    }
    return ret;
  };

  var _formatArray = function (obj, cur_depth, pad_val, pad_char) {
    var someProp = '';
    if (cur_depth > 0) {
      cur_depth++;
    }

    var base_pad = _repeat_char(pad_val * (cur_depth - 1), pad_char);
    var thick_pad = _repeat_char(pad_val * (cur_depth + 1), pad_char);
    var str = '';
    var val = '';

    if (typeof obj === 'object' && obj !== null) {
      if (obj.constructor && _getFuncName(obj.constructor) === 'PHPJS_Resource') {
        return obj.var_dump();
      }
      lgth = 0;
      for (someProp in obj) {
        lgth++;
      }
      str += 'array(' + lgth + ') {\n';
      for (var key in obj) {
        var objVal = obj[key];
        if (typeof objVal === 'object' && objVal !== null && !(objVal instanceof Date) && !(objVal instanceof RegExp) && !objVal.nodeName) {
          str += thick_pad + '[' + key + '] =>\n' + thick_pad + _formatArray(objVal, cur_depth + 1, pad_val, pad_char);
        } else {
          val = _getInnerVal(objVal, thick_pad);
          str += thick_pad + '[' + key + '] =>\n' + thick_pad + val + '\n';
        }
      }
      str += base_pad + '}\n';
    } else {
      str = _getInnerVal(obj, thick_pad);
    }
    return str;
  };

  output = _formatArray(arguments[0], 0, pad_val, pad_char);
  for (i = 1; i < arguments.length; i++) {
    output += '\n' + _formatArray(arguments[i], 0, pad_val, pad_char);
  }

  if (d.body) {
    this.echo(output);
  } else {
    try {
      d = XULDocument; 
      this.echo('<pre xmlns="http://www.w3.org/1999/xhtml" style="white-space:pre;">' + output + '</pre>');
    } catch (e) {
      this.echo(output); 
    }
  }
}

function echo () {
  var arg = '',
    argc = arguments.length,
    argv = arguments,
    i = 0,
    holder, win = this.window,
    d = win.document,
    ns_xhtml = 'http://www.w3.org/1999/xhtml',
    ns_xul = 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul'; // If we're in a XUL context
  var stringToDOM = function (str, parent, ns, container) {
    var extraNSs = '';
    if (ns === ns_xul) {
      extraNSs = ' xmlns:html="' + ns_xhtml + '"';
    }
    var stringContainer = '<' + container + ' xmlns="' + ns + '"' + extraNSs + '>' + str + '</' + container + '>';
    var dils = win.DOMImplementationLS,
      dp = win.DOMParser,
      ax = win.ActiveXObject;
    if (dils && dils.createLSInput && dils.createLSParser) {
      // Follows the DOM 3 Load and Save standard, but not
      // implemented in browsers at present; HTML5 is to standardize on innerHTML, but not for XML (though
      // possibly will also standardize with DOMParser); in the meantime, to ensure fullest browser support, could
      // attach http://svn2.assembla.com/svn/brettz9/DOMToString/DOM3.js (see http://svn2.assembla.com/svn/brettz9/DOMToString/DOM3.xhtml for a simple test file)
      var lsInput = dils.createLSInput();
      // If we're in XHTML, we'll try to allow the XHTML namespace to be available by default
      lsInput.stringData = stringContainer;
      var lsParser = dils.createLSParser(1, null); // synchronous, no schema type
      return lsParser.parse(lsInput).firstChild;
    } else if (dp) {
      // If we're in XHTML, we'll try to allow the XHTML namespace to be available by default
      try {
        var fc = new dp().parseFromString(stringContainer, 'text/xml');
        if (fc && fc.documentElement && fc.documentElement.localName !== 'parsererror' && fc.documentElement.namespaceURI !== 'http://www.mozilla.org/newlayout/xml/parsererror.xml') {
          return fc.documentElement.firstChild;
        }
        // If there's a parsing error, we just continue on
      } catch (e) {
        // If there's a parsing error, we just continue on
      }
    } else if (ax) { // We don't bother with a holder in Explorer as it doesn't support namespaces
      var axo = new ax('MSXML2.DOMDocument');
      axo.loadXML(str);
      return axo.documentElement;
    }
/*else if (win.XMLHttpRequest) { // Supposed to work in older Safari
      var req = new win.XMLHttpRequest;
      req.open('GET', 'data:application/xml;charset=utf-8,'+encodeURIComponent(str), false);
      if (req.overrideMimeType) {
        req.overrideMimeType('application/xml');
      }
      req.send(null);
      return req.responseXML;
    }*/
    // Document fragment did not work with innerHTML, so we create a temporary element holder
    // If we're in XHTML, we'll try to allow the XHTML namespace to be available by default
    //if (d.createElementNS && (d.contentType && d.contentType !== 'text/html')) { // Don't create namespaced elements if we're being served as HTML (currently only Mozilla supports this detection in true XHTML-supporting browsers, but Safari and Opera should work with the above DOMParser anyways, and IE doesn't support createElementNS anyways)
    if (d.createElementNS && // Browser supports the method
    (d.documentElement.namespaceURI || // We can use if the document is using a namespace
    d.documentElement.nodeName.toLowerCase() !== 'html' || // We know it's not HTML4 or less, if the tag is not HTML (even if the root namespace is null)
    (d.contentType && d.contentType !== 'text/html') // We know it's not regular HTML4 or less if this is Mozilla (only browser supporting the attribute) and the content type is something other than text/html; other HTML5 roots (like svg) still have a namespace
    )) { // Don't create namespaced elements if we're being served as HTML (currently only Mozilla supports this detection in true XHTML-supporting browsers, but Safari and Opera should work with the above DOMParser anyways, and IE doesn't support createElementNS anyways); last test is for the sake of being in a pure XML document
      holder = d.createElementNS(ns, container);
    } else {
      holder = d.createElement(container); // Document fragment did not work with innerHTML
    }
    holder.innerHTML = str;
    while (holder.firstChild) {
      parent.appendChild(holder.firstChild);
    }
    return false;
    // throw 'Your browser does not support DOM parsing as required by echo()';
  };


  var ieFix = function (node) {
    if (node.nodeType === 1) {
      var newNode = d.createElement(node.nodeName);
      var i, len;
      if (node.attributes && node.attributes.length > 0) {
        for (i = 0, len = node.attributes.length; i < len; i++) {
          newNode.setAttribute(node.attributes[i].nodeName, node.getAttribute(node.attributes[i].nodeName));
        }
      }
      if (node.childNodes && node.childNodes.length > 0) {
        for (i = 0, len = node.childNodes.length; i < len; i++) {
          newNode.appendChild(ieFix(node.childNodes[i]));
        }
      }
      return newNode;
    } else {
      return d.createTextNode(node.nodeValue);
    }
  };

  var replacer = function (s, m1, m2) {
    // We assume for now that embedded variables do not have dollar sign; to add a dollar sign, you currently must use {$$var} (We might change this, however.)
    // Doesn't cover all cases yet: see http://php.net/manual/en/language.types.string.php#language.types.string.syntax.double
    if (m1 !== '\\') {
      return m1 + eval(m2);
    } else {
      return s;
    }
  };

  this.php_js = this.php_js || {};
  var phpjs = this.php_js,
    ini = phpjs.ini,
    obs = phpjs.obs;
  for (i = 0; i < argc; i++) {
    arg = argv[i];
    if (ini && ini['phpjs.echo_embedded_vars']) {
      arg = arg.replace(/(.?)\{?\$(\w*?\}|\w*)/g, replacer);
    }

    if (!phpjs.flushing && obs && obs.length) { // If flushing we output, but otherwise presence of a buffer means caching output
      obs[obs.length - 1].buffer += arg;
      continue;
    }

    if (d.appendChild) {
      if (d.body) {
        if (win.navigator.appName === 'Microsoft Internet Explorer') { // We unfortunately cannot use feature detection, since this is an IE bug with cloneNode nodes being appended
          d.body.appendChild(stringToDOM(ieFix(arg)));
        } else {
          var unappendedLeft = stringToDOM(arg, d.body, ns_xhtml, 'pre'); // We will not actually append the div tag (just using for providing XHTML namespace by default)
          if (unappendedLeft) {
            d.body.appendChild(unappendedLeft);
          }
        }
      } else {
        d.documentElement.appendChild(stringToDOM(arg, d.documentElement, ns_xul, 'description')); // We will not actually append the description tag (just using for providing XUL namespace by default)
      }
    } else if (d.write) {
      d.write(arg);
    }
/* else { // This could recurse if we ever add print!
      print(arg);
    }*/
  }
}
