/**
 * Klasa zawierająca metody do zarządzania formularzami, AJAX;
 *
 * @package     sfJSPlugin
 * @subpackage  core

 * @version     0.1-DEV
 * @type {Class}
 */

var Form = new Class({
  initialize: function() {
    // Inicjalizacja Klasy Formularza w JS

      }
}).extend({
  hideNotice: function() {
    $('.error-popup').hide();
    $('.info-popup').hide();
  },
  /**
   * Success zapisu formularza.
   *
   * @param element
   * @param data
   */
  success: function(element, data) {

    if (!is_object(data)) {
      var data = JSON.parse(data);
    }

    Form.hideNotice();

    if (data == 'NoPermission') {
      alert('Nie posiadasz praw aby wykonać tą czynność')
    } else {

      if (isset(data.HTML)) {
        Debug.info('[Form] Wczytano od nowa HTML formularza.');

        if (data.MODAL) {
          element.unspin();
          AjaxLoader.loadBeforeAjax();
          $('#modalContainer').html(data.HTML.value);
        } else {
            if (isset(data.ISVALID) && !data.ISVALID) {
              $('#modalContainer').html(data.HTML.value);
            } else { 
              element.html(data.HTML.value);
            }

          element.find("script").each(function(i) {
            eval($(this).text());
          });
        }
      }

      if (isset(data.NOTICE)) {

        Debug.info("[Form] Ustawia powiadomienie");
        var _type = data.NOTICE.type;
        var _notice = data.NOTICE.value;

        $('.' + _type + '-popup-text').html(_notice);
        $('.' + _type + '-popup').show("slow");
        $('[scrollarea="true"]').mCustomScrollbar({
            scrollInertia: 250,
            scrollButtons: {
                enable: true
            }
        });
      } else {
        Form.hideNotice();
      }

      
      Debug.info('[Form ]Kompomenty do zmiany : ');

      Object.each(data.Components, function(value, key) {
        JsRequest.parseComponent(key, value);
      });
    }


    if (data.MODAL) {
      AjaxLoader.loadAfterAjax(false);
    } else {
      element.unspin();
      AjaxLoader.loadAfterAjax(true);
    }
  },
  setError: function(text) {
    $('.error-popup-text').html(text);
    $('.error-popup').show("slow");
  },
  setInfo: function(text) {
    $('.info-popup-text').html(text);
    $('.info-popup').show("slow");
  },
  /**
   * Ładowanie formularza.
   *
   * @param element
   */
  loading: function(element) {
    if ($('.modal-spinner').length > 0) {
        $('.modal-spinner').show();
    } else if ($('.global-spinner').length > 0) {
        $('.global-spinner').show();
    } else {
        element.spin();
    }
  },
  /**
   * Błąd podczas zapisu formularza.
   *
   * @param element
   */
  error: function(element) {
    $('.modal-spinner').hide();
    $('.global-spinner').hide();
    $('.modal-backdrop').remove();
    element.unspin();
  }
});


//function tmp(cos){
//    if($(cos).hasClass('active'))
//    {
//        $(cos).removeClass('active');
//    }
//    else{
//        alert(cos);
//        $(cos).remove(this);
//    }
//}