/**
 * Klasa zawierająca metody do obsługi łączonych requestów JSON. 
 *
 * @package     sfJSPlugin
 * @subpackage  request

 * @version     0.1-DEV
 * @type {Class}
 */
var JsRequest = new Class({
  routing: 'sf_js_responder',
  initialize: function() {
      },
  send: function(params) {

    Form.hideNotice();

    var _url = Routing.generate(this.routing, params),
            _that = new JsRequest();

    _jsonRequest = new Request.JSON({
      url: _url,
      onSuccess: function(responseJSON, responseText) {
        _that.parseJSON(responseJSON);
      },
    }).post(params);
  },
  parseJSON: function(response) {
    if (isset(response)) {
      Object.each(response, function(value, key) {
        JsRequest.parseComponent(key, value);
      });
    }
  },
}).extend({
  parseJSON: function(response) {
    if (isset(response)) {
      Object.each(response, function(value, key) {
        JsRequest.parseComponent(key, value);
      });
    }
  },
  parseComponent: function(component, params) {

    var _component = component.toString();

    if (Object.keys(params) == "HTML") {

      var _html = params.HTML.value.toString();
      var _id = params.HTML.id.toString();

      Debug.info('[JsRequest] Komponent : ' + _component + ' zwraca HTML do ID : ' + _id);

    } else if (Object.keys(params) == "JSON") {

      var _id = params.JSON.id;
      var _functions = params.JSON.value;

      Debug.info('[JsRequest] Komponent : ' + _component + ' zwraca funkcje JS ');

      Object.each(_functions, function(value, key) {
        Debug.info("[JsRequest] Uruchomiono : " + key.toString() + "{" + CoreTimer.timestamp() + "}");
        eval(key.toString() + '(' + JsRequest.parseParams(value) + ')');
      });

    } else {
      Debug.error("[JsRequest] JsRequest, podany typ nie został zadefiniowany : " + Object.keys(params));
    }
  },
  parseParams: function(parameters) {
    var _string = '';

    Object.each(parameters, function(value, key) {
      if (key == 0) {
        _string += '"' + escape(value.toString()) + '"';
      } else {
        _string += ',' + '"' + escape(value.toString()) + '"';
      }
    });

    Config.debug = false;
    Debug.info('[JsRequest] Parametry : ' + _string);
    Config.debug = true;
    return _string;
  },
});

var Redirect = new Class({
}).extend({
  url: function(name, params) {
    Debug.info("[Redirect] Przekierowanie  do : " + Routing.generate(name, params));
    window.location = Routing.generate(name, params);
  }
});