Request.Queue = new Class({
  Implements: [Options, Events],
  Binds: ['attach', 'request', 'complete', 'cancel', 'success', 'failure', 'exception'],
  options: {
    stopOnFailure: true,
    autoAdvance: true,
    concurrent: 1,
    requests: {},
    iterator: 0
  },
  initialize: function(options) {
    var requests;
    if (options) {
      requests = options.requests;
      delete options.requests;
    }
    this.setOptions(options);
    this.requests = {};
    this.iterator = 0;
    this.queue = [];
    
    this.reqBinders = {};

    if (requests)
      this.addRequests(requests);

    Debug.info("[Request.Queue] Zainicjalizowano kolejkę Requestów");
  },
  addRequest: function(request, name) {

    if (!name && typeOf(name) != 'string')
      name = this.iterator;
    
    this.requests[name] = request;
//    this.attach(name, request);
    this.iterator++;

    Debug.info('[Request.Queue] Dodano request o kluczu: ' + name);
    return this;
  },
  addRequests: function(obj) {
    Object.each(obj, function(req, name) {
      this.addRequest(req, name);
    }, this);
    return this;
  },
  getRequest: function(name) {
    return request = this.requests[name];
  },
  getFirstRequest: function() {

    if (this.iterator == 0) {
      Debug.error("[Request.Queue] Kolejka nie posiada jeszcze żadnych elementów");
    } else {
      return this.requests[0];
    }
  },
  getLastRequest: function() {
    if (this.iterator == 0) {
      Debug.error("[Request.Queue] Kolejka nie posiada jeszcze żadnych elementów");
    } else {
      key = this.iterator - 1;
      return this.requests[key];
    }
  },
  getNthRequest: function(n) {

    if (this.iterator < n) {
      Debug.error("[Request.Queue] Kolejka nie posiada tylu elementów : [ " + n + " ]");
    } else {
      return this.requests[n];
    }
  },
  runFirstRequest: function() {
    this.getFirstRequest().send();
  },
  runLastRequest: function() {
    this.getLastRequest().send();
  },
  runNthRequest: function(n) {
    this.getNthRequest(n).send();
  },
  getName: function(req) {
    return Object.keyOf(this.requests, req);
  },
  attach: function(name, req) {
    
    /**
     *  Podmienia REQ / Trzeba Clone zrobić. @K
     */
    if (req._groupSend)
      return this;
    ['request', 'complete', 'cancel', 'success', 'failure', 'exception'].each(function(evt) {
      
      if (!this.reqBinders[name])
        this.reqBinders[name] = {};
      
      this.reqBinders[name][evt] = function() {
        this['on' + evt.capitalize()].apply(this, [name, req].append(arguments));
      }.bind(this);
      
      req.addEvent(evt, this.reqBinders[name][evt]);
      
    }, this);
    
    req._groupSend = req.send;
    
    req.send = function(options) {
      this.send(name, options);
      return req;
    }.bind(this);
    
    return this;
  },
  removeRequest: function(req) {
    var name = typeOf(req) == 'object' ? this.getName(req) : req;
    if (!name && typeOf(name) != 'string')
      return this;
    req = this.requests[name];
    if (!req)
      return this;
    ['request', 'complete', 'cancel', 'success', 'failure', 'exception'].each(function(evt) {
      req.removeEvent(evt, this.reqBinders[name][evt]);
    }, this);
    req.send = req._groupSend;
    delete req._groupSend;
    return this;
  },
  getRunning: function() {
    return Object.filter(this.requests, function(r) {
      return r.running;
    });
  },
  isRunning: function() {
    return !!(Object.keys(this.getRunning()).length);
  },
  send: function(name, options) {
    var q = function() {
      this.requests[name]._groupSend(options);
      this.queue.erase(q);
    }.bind(this);

    q.name = name;
    if (Object.keys(this.getRunning()).length >= this.options.concurrent || (this.error && this.options.stopOnFailure))
      this.queue.push(q);
    else
      q();
    return this;
  },
  hasNext: function(name) {
    return (!name) ? !!this.queue.length : !!this.queue.filter(function(q) {
      return q.name == name;
    }).length;
  },
  resume: function() {
    this.error = false;
    (this.options.concurrent - Object.keys(this.getRunning()).length).times(this.runNext, this);
    return this;
  },
  runNext: function(name) {
    if (!this.queue.length)
      return this;
    if (!name) {
      this.queue[0]();
    } else {
      var found;
      this.queue.each(function(q) {
        if (!found && q.name == name) {
          found = true;
          q();
        }
      });
    }
    return this;
  },
  runAll: function() {
    this.queue.each(function(q) {
      q();
    });
    return this;
  },
  clear: function(name) {
    if (!name) {
      this.queue.empty();
    } else {
      this.queue = this.queue.map(function(q) {
        if (q.name != name)
          return q;
        else
          return false;
      }).filter(function(q) {
        return q;
      });
    }
    return this;
  },
  cancel: function(name) {
    this.requests[name].cancel();
    return this;
  },
  onRequest: function() {
    this.fireEvent('request', arguments);
  },
  onComplete: function() {
    this.fireEvent('complete', arguments);
    if (!this.queue.length)
      this.fireEvent('end');
  },
  onCancel: function() {
    if (this.options.autoAdvance && !this.error)
      this.runNext();
    this.fireEvent('cancel', arguments);
  },
  onSuccess: function() {
    if (this.options.autoAdvance && !this.error)
      this.runNext();
    this.fireEvent('success', arguments);
  },
  onFailure: function() {
    this.error = true;
    if (!this.options.stopOnFailure && this.options.autoAdvance)
      this.runNext();
    this.fireEvent('failure', arguments);
  },
  onException: function() {
    this.error = true;
    if (!this.options.stopOnFailure && this.options.autoAdvance)
      this.runNext();
    this.fireEvent('exception', arguments);
  }
});