
$(function()
	{
	/**
	 * Array of elements
	 */
	var elements = [];
	var counter = 0;

	for(var i=1;i<=5;++i) for(var j=1;j<=3;++j)
		{
		if(((i === 3) && (j > 2)) || ((i === 5) && (j > 1))) break;

		elements[counter++] = {'kind': i, 'item': j};
		}

	/**
	 * Place elements in random order
	 */
	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value.kind+'_'+value.item+'" data-kind="'+value.kind+'" data-item="'+value.item+'"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);
                $(this).attr( "data-dropped", 0);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var kind = [[0,0,0,0,0],[0,0,0,0,0],[0,0,0,0,0],[0,0,0,0,0],[0,0,0,0,0]];

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.click(function() {
			$('#jplayer_sound_'+$this.data('kind')).jPlayer('play');
			});

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,

                        out: function( event, ui )
                                {

                                    if (ui.draggable.attr('data-dropped') === "1")
                                            {
                                            ui.draggable.attr( 'data-dropped', "0");
                                            if (kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1] > 0) kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1]--;
                                            }
                                },

			drop: function(event,ui)
				{
				 if (ui.draggable.attr('data-dropped') === "0")
                                     {
                                        ui.draggable.attr( 'data-dropped', "1");
                                        kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1]++;


                                      }

				}
			});
		});

	/**
	 * Sound
	 */



	for(var i=1;i<=5;++i)
		{
		$('#jplayer_sound_'+i).jPlayer(
			{
			ready: function()
				{
				$(this).jPlayer('setMedia', {mp3: './media/file.mp3'});
				},

			play: function()
				{
				$(this).jPlayer('pauseOthers');
				},

			swfPath: '../../styles/flash',
			supplied: 'mp3'
			});

			if ((i===1) && (j===4)) break;
		}


	$('#jplayer_sound_1').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound_1').jPlayer('setMedia', {mp3: './media/drewno.mp3'});
		});

	$('#jplayer_sound_2').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound_2').jPlayer('setMedia', {mp3: './media/metal.mp3'});
		});

	$('#jplayer_sound_3').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound_3').jPlayer('setMedia', {mp3: './media/plastik.mp3'});
		});

	$('#jplayer_sound_4').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound_4').jPlayer('setMedia', {mp3: './media/szklo.mp3'});
		});

	$('#jplayer_sound_5').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound_5').jPlayer('setMedia', {mp3: './media/glina.mp3'});
		});









	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();
		var ok = false;
		if ((kind[0][0] === 3) && (kind[1][1] === 3) && (kind[2][2] === 2) && (kind[3][3] === 3) && (kind[4][4] === 1)) ok = true;
		if(ok)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});

