$(function() {

    var zindex = 10,
            dropped = 0;

    $('.dragg').draggable({
        start: function() {
            var z = $(this).css('z-index');
            zindex++;
            $(this).css('z-index', z + zindex);
        }
    });

    var drop = function(event, ui) {
        if (ui.draggable.data('dropped') === 0) {
            ui.draggable.data('dropped', 1);
            var position = $(this).position();
            ui.draggable
                    .css('top', position.top)
                    .css('left', position.left)
                    .css('z-index', 5);
            dropped++;
            if (dropped === 16) {
                $('#jplayer_well').jPlayer('play');
            }
        }
    };

    var out = function(event, ui) {
        if (ui.draggable.data('dropped') === 1) {
            ui.draggable.data('dropped', 0);
            dropped--;
        }
    };

    $('.target').each(function() {
        $(this).droppable({
            accept: '.' + $(this).data('type'),
            tolerance: "intersect",
            drop: drop,
            out: out
        });
    });
});