$(function () {
    var accept = [
        ['21020', '10220'],
        ['5525'],
        ['5945', '9545'],
        ['20254590', '20452590', '25204590', '25452090', '45202590', '45252090']
    ],
            zadDigits = [5, 4, 4, 8];

    function getLengthZadDigits(z) {
        for (var i = 0, digits = 0; i < $('#z' + z)[0].childElementCount; i++) {
            digits += $('#z' + z + ' input:nth-child(' + (i + 1) + ')').val().length;
        }
        return digits;
    }

    function getValueZad(z) {
        for (var i = 0, val = ''; i < $('#z' + z)[0].childElementCount; i++) {
            var $this = $('#z' + z + ' input:nth-child(' + (i + 1) + ')');
            val += $this.val();
        }
        return val;
    }

    $("input").each(function () {
        var readOnly = $(this)[0].readOnly;
        if (!readOnly) $(this).val('');
        $(this).attr('disabled', false);
    });

    $('input').keyup(function () {
        var zad = $(this).parent().data('value');
        if (getLengthZadDigits(zad) === zadDigits[zad]) {
            var index = accept[zad].indexOf(getValueZad(zad));
            if (index < 0) {
                $('#z' + zad + ' input').val('');
                $('#jplayer_wrong').jPlayer('play');
            } else {
                $('#jplayer_well').jPlayer('play');
                $('#z' + zad + ' input').attr('disabled', true).css('color', 'green');
            }
        }
    });
});