$(function()
{
	var sounds = [["plane",0],["boat",1],["bus",2],["train",3],["bicycle",4],['car',5]];
	var turn = 0;
	shuffleArray(sounds);
	for(var i=0;i<=5;++i)
		{
		$('#jplayer_sound'+i).jPlayer(
			{
			ready: function()
				{
				$(this).jPlayer('setMedia', {mp3: './media/'+sounds[$(this).data('value')][0]+'.mp3'});
				},
			play: function()
				{
				$(this).jPlayer('pauseOthers', 0);
				},
			swfPath: '../../styles/flash',
			supplied: 'mp3'
			});
		}
		
	$('#jplayer').on($.jPlayer.event.ended,function(event)
		{
			maketurn();
		});
	
	$(".letterinput").val('').prop('disabled', false);
	
	
	$("input").bind("input", function () {
		var $this = $(this);
		setTimeout(function () {
			if ($this.val().length >= parseInt($this.attr("maxlength"), 10)) {

				if ($this.data('value') === sounds[turn][1] && Number($this.val().toLowerCase()) === turn+1)
				{
				$this.prop('disabled', true).css({'border-color':'#3F931B','color':'#3F931B'});
				$('#jplayer_well').jPlayer('play');
				turn++;
				maketurn();
				} else 
				{
					$this.val('');
					$('#jplayer_wrong').jPlayer('play');
					setTimeout(function(){
					$('#jplayer_sound'+turn).jPlayer('play');
					},2000);
				}
			}
		}, 100);
	});
	
	function maketurn(){

		setTimeout(function(){
			$('#jplayer_sound'+turn).jPlayer('play');
		},300);
	}
	
	function shuffleArray(array) {
		for (var i = array.length - 1; i > 0; i--) {
			var j = Math.floor(Math.random() * (i + 1));
			var temp = array[i];
			array[i] = array[j];
			array[j] = temp;
		}
		return array;
	}
});
